% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mathEfrontCashRisky.R
\name{mathEfrontCashRisky}
\alias{mathEfrontCashRisky}
\title{Math Efficient Frontier: Cash and Risky Assets}
\usage{
mathEfrontCashRisky(
  returns,
  npoints = 10,
  rf = 0.003,
  plot.efront = TRUE,
  stock.names = TRUE,
  values = FALSE,
  scalex = 1.1,
  scaley = 1.1,
  cexPoints = 0.8,
  cexText = 0.8
)
}
\arguments{
\item{returns}{Risky asset returns multivariate xts object}

\item{npoints}{Number of efficient frontier points with default 10}

\item{rf}{A risk-free rate with default 0.003}

\item{plot.efront}{Logical variable which if TRUE results in a plot of}

\item{stock.names}{Logical variable with default TRUE}

\item{values}{Logical variable for returning efront values with default FALSE}

\item{scalex}{Horizontal axis scale parameter with default 1.1}

\item{scaley}{Vertical axis scale parameter with default 1.1}

\item{cexPoints}{Numerical size parameter for points with default 0.8}

\item{cexText}{Numerical size parameter for text with default 0.8}
}
\value{
default is no value returned, and a plot is displayed of the linear
efficient frontier.  Optionally, a numeric object containing the weights along
the linear efficient frontier are displayed. Optionally no plot is displayed.
}
\description{
This function computes and plots a linear efficient frontier that is
a mix of a risk-free asset ("cash") and risky stocks (or other assets).
It optionally returns the weights along the linear efficient frontier.
}
\examples{
args(mathEfrontCashRisky)
}
