% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/earlyreg.R
\name{earlyreg}
\alias{earlyreg}
\title{A function to calculate the slope and intercept of an amplification curve data
from a quantitative PCR experiment.}
\usage{
earlyreg(x, y, range = 5, normalize = FALSE)
}
\arguments{
\item{x}{is the cycle numbers (x-axis).}

\item{y}{is the cycle dependent fluorescence amplitude (y-axis).}

\item{range}{is the number of cycles to be used for the regression.}

\item{normalize}{is a logical parameter which indicates if the amplification curve
data should be normalized to the 99 percent percentile of the amplification curve.}
}
\value{
gives a \code{numeric} vector (S3 class, type of \code{double}) as 
output for local regression
}
\description{
\code{earlyreg} is a function to calculate the slope and intercept of an
amplification curve data from a quantitative PCR experiment. The number
of cycles to be analyzed is defined by the user (default 6 cycles).
The output contains the Maximal Information Coefficient (MIC), which
can be interpreted as a correlation measure with a range of [0,1].
A value of 0 mean statistically independent data and 1 approaches
in "probability for noiseless functional relationships" (see
original study by Reshef, D. N. et al. Detecting novel associations in
large data sets. Science, 334, 1518-1524 (2011)).
}
\examples{
# Calculate slope and intercept on noise (negative) amplification curve data
# for the cycles 2 to 7 for the C316.amp data set
library(chipPCR)
data(C316.amp)

# Plot the data
plot(C316.amp[, 2], y=C316.amp[, 3], xlab="Cycle", ylab="RFU",
     main="C316.amp data set", lty=1, type="l")
res <- earlyreg(x=C316.amp[, 2], y=C316.amp[, 3], range=5)
res
}
\author{
Stefan Roediger, Michal Burdukiewcz
}
\keyword{intercept}
\keyword{slope}
