% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Parameter_estimation_and_hypothesis_testing.R
\name{mult.sample.test}
\alias{mult.sample.test}
\title{Test for \eqn{\psi} of multiple samples}
\usage{
mult.sample.test(x)
}
\arguments{
\item{x}{The data array to be tested. Each column of \code{x} is an independent sample.}
}
\value{
Gives a vector with the Likelihood Ratio Test -statistic \code{Lambda}, as well as the
p-value of the test \code{p}.
}
\description{
Likelihood ratio test for the hypotheses \eqn{H_0: \: \psi_1=\psi_2=...=\psi_d} and
\eqn{H_1: \: \psi_1 \neq \psi_2 \neq ... \neq \psi_d}, where \eqn{\psi_1,\psi_2,}...\eqn{,\psi_d} are the
dispersal parameters of the \eqn{d} samples in the columns of the input data array \code{x}.
}
\details{
Calculates the Likelihood Ratio Test statistic
\deqn{-2log(L(\hat{\psi})/L(\hat{\psi}_1, \hat{\psi}_2, ..., \hat{\psi}_d)),}
where L is the likelihood function of observing the \eqn{d} input samples given
a single \eqn{\psi} in the numerator and \eqn{d} different parameters \eqn{\psi_1,\psi_2,}...\eqn{,\psi_d}
for each sample respectively in the denominator. According
to the theory of Likelihood Ratio Tests, this statistic converges in
distribution to a \eqn{\chi_{d-1}^2}-distribution when the null-hypothesis is true, where \eqn{d-1} is the
difference in the amount of parameters between the considered models. To
calculate the statistic, the Maximum Likelihood Estimate for
\eqn{\psi_1,\: \psi_2,\: ..., \: \psi_d} of \eqn{H_1} and the shared \eqn{\psi} of \eqn{H_0}
are calculated.
}
\examples{
##Create samples with different n and psi:
set.seed(111)
x<-rPD(1200, 15)
y<-c( rPD(1000, 20), rep(NA, 200) )
z<-c( rPD(800, 30), rep(NA, 400) )
samples<-cbind(cbind(x, y), z)
##Run test
mult.sample.test(samples)
}
\references{
Neyman, J., & Pearson, E. S. (1933). On the problem of the most
efficient tests of statistical hypotheses. Philosophical Transactions of the
Royal Society of London. Series A, Containing Papers of a Mathematical Or
Physical Character, 231(694-706), 289-337. <\doi{10.1098/rsta.1933.0009}>.
}
