% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PH1XBAR-package.R
\docType{package}
\name{PH1XBAR-package}
\alias{PH1XBAR-package}
\title{PH1XBAR: Phase I Shewhart X-Bar Chart}
\description{
The purpose of 'PH1XBAR' is to build a Phase I Shewhart control chart for the basic Shewhart, the variance components and the ARMA models in R for subgrouped and individual data. More details can be found: Yao and Chakraborti (2020) \doi{ 10.1002/qre.2793}, Yao and Chakraborti (2021) \doi{ 10.1080/08982112.2021.1878220}, and Yao et al. (2023) \doi{ 10.1080/00224065.2022.2139783}.

The utility of this package is in building a Shewhart-type control chart based on new methods for subgrouped and individual data. The Phase I chart is based on the multivariate normal/t or ARMA process.
}
\examples{
#Build a Phase I basic Shewhart control chart
data(grinder_data)
PH1XBAR(grinder_data, nsim=10)

# Build a Phase I individual control chart with an ARMA model
data(preston_data)
PH1ARMA(preston_data, nsim.process=10, nsim.coefs=10)

}
\references{
Champ, C.W., and Jones, L.A. (2004) Designing Phase I X-bar charts with small sample sizes. Quality and Reliability Engineering International. 20(5), 497-510

Yao, Y., Hilton, C.W., and Chakraborti, S. (2017) Designing Phase I Shewhart X-bar charts: Extended tables and software. Quality and Reliability Engineering International. 33(8), 2667-2672.

Yao, Y., and Chakraborti, S. (2021). Phase I monitoring of individual normal data: Design and implementation. Quality Engineering, 33(3), 443-456.

Yao, Y., and Chakraborti, S. (2021). Phase I process monitoring: The case of the balanced one-way random effects model. Quality and Reliability Engineering International, 37(3), 1244-1265.

Yao, Y., Chakraborti, S., Yang, X., Parton, J., Lewis Jr, D., and Hudnall, M. (2023). Phase I control chart for individual autocorrelated data: application to prescription opioid monitoring. Journal of Quality Technology, 55(3), 302-317.
}
\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/bolus123/PH1XBAR}
}

}
\author{
\strong{Maintainer}: Yuhui Yao \email{yyao17@ua.edu}

Other contributors:
\itemize{
  \item Subha Chakraborti \email{schakrab@ua.edu} [contributor]
  \item Tyler Thomas \email{tjthomas7@crimson.ua.edu} [contributor]
  \item Jason Parton \email{jmparton@ua.edu} [contributor]
  \item Xin Yang \email{xyang15@cba.ua.edu} [contributor]
}

}
\keyword{package}
