#' PIE: A Partially Interpretable Model with Black-box Refinement
#'
#' The PIE package implements a novel Partially Interpretable Model (PIE) framework
#' introduced by Wang et al. <arxiv:2105.02410>. This framework jointly train an interpretable model
#' and a black-box model to achieve high predictive performance as well as partial model transparency.
#'
#' @section Functions:
#' - \code{predict.PIE()}: Main function for generating predictions with the PIE model on dataset.
#' - \code{PIE()}: Main function for training the PIE model with dataset.
#' - \code{data_process()}: Process data into the format that can be used by PIE model.
#' - \code{sparsity_count()}: Counts the number of features used in group lasso.
#' - \code{RPE()}: Evaluate the RPE of a PIE model.
#' - \code{MAE()}: Evaluate the MAE of a PIE model.
#'
#'
#'
#' For more details, see the documentation for individual functions.
#' @importFrom stats predict coef
#' @importFrom splines ns
#' @import gglasso
#' @import xgboost
#'
#' @name PIE
#' @keywords intrepretable-machine-learning
"_PACKAGE"

#' Wine Quality Data
#'
#' A benchmark data set.
#'
#' @name winequality
#' @aliases winequality
#' @title Wine Quality Data
#'
#' @usage
#' data(winequality)
#'
#' @description
#' This dataset contains 5197 data points. It is related to Portuguese `Vinho Verdo` wine. Input variables are based on physicochemical tests.
#' This dataset can also be found at [Wine Quality](https://archive.ics.uci.edu/dataset/186/wine+quality) in UC Irvine Machine Learning Repository.
#'
#' @return
#' A matrix with 5197 rows and 13 columns. The first 11 columns are numerical variables, the 12th column contains categorical variable, and the last column is the response.
#' 
#' @source
#' The data were introduced in Cortez et al. (2009).
#'
#' @references
#' Cortez, P., Cerdeira, A., Almeida, F., Matos, T., & Reis, J. (2009). 
#' ``Modeling wine preferences by data mining from physicochemical properties,''
#' \emph{Decision Support Systems}, \bold{47}(4), 547-553.
#'
#' @examples
#' # Load the PIE library
#' library(PIE)
#'
#' # Load the dataset
#' data(winequality)
#'
#' @keywords data set
NULL




