% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_ss_analytic.R
\name{calc_ss_analytic}
\alias{calc_ss_analytic}
\title{Returns the state of a linear PK system at steady state (trough)
using analytics equations (so for linear PK systems only).}
\usage{
calc_ss_analytic(
  f = "1cmt_oral",
  dose,
  interval,
  t_inf = NULL,
  model,
  parameters,
  covariates = NULL,
  map = NULL,
  n_days = 45,
  n_transit_compartments = 0,
  auc = FALSE
)
}
\arguments{
\item{f}{analytic equation to use, must be one of \code{names(advan_funcs)}}

\item{dose}{dose}

\item{interval}{interval}

\item{t_inf}{infusion time}

\item{model}{PKPDsim model}

\item{parameters}{parameters list}

\item{covariates}{covariates list}

\item{map}{list for remapping parameters, ex: \code{list(CL = "CL", V = "V")}}

\item{n_days}{number of days at which to assume steady state. Default is 45.}

\item{n_transit_compartments}{number of transit compartments, will insert n compartments between the first (dose) compartment and the second (central) compartment.}

\item{auc}{add (empty) AUC compartment at end of state vector?}
}
\value{
State vector of a linear pharmacokinetic system at steady state
}
\description{
Basically it performs a PK simulation using analytic equations instead
of ODEs to steady state (n=45 days, increased if needed).
}
\details{
It can also be used for models with transit compartments, however,
the assumption is made that at the end of the dosing interval the
amount in the transit compartments is negligible (0).
}
