% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ReptTraits.R
\docType{data}
\name{ReptTraits}
\alias{ReptTraits}
\title{ReptTraits: A Comprehensive Dataset of Ecological Traits in Reptiles}
\format{
A data frame with the following columns:
\describe{
  \item{species}{Scientific species name}
  \item{genus}{Genus name}
  \item{family}{Family name}
  \item{Minimal_elevation}{Minimum elevation where the species was observed (meters above sea level)}
  \item{Maximum_elevation}{Maximum elevation where the species was observed (meters above sea level)}
  \item{Mean_Annual_Temperature}{Mean annual temperature,°C}
  \item{Temperature_Seasonality}{Temperature seasonality, standard deviation × 100}
  \item{Seasonality_Precipitation}{Seasonal precipitation information}
  \item{Maximum_Longevity}{Longevity data are the maximum age reported for each species from the literature, years}
  \item{Maximum_body_mass}{Maximum body mass of the species (grams)}
  \item{Maximum_length}{Maximum length ("SVL", mm)/straight carapace length for turtles ("SCL", mm)}
  \item{Mean_number_of_offspring}{Mean number of offspring or eggs per clutch}
  \item{Smallest_clutch_size}{Minimum clutch/litter size}
  \item{Largest_clutch_size}{Maximum clutch/litter size}
  \item{Mean_Tb}{The mean reported mean body temperatures of animal, °C}
}
}
\usage{
ReptTraits
}
\description{
A comprehensive dataset containing ecological and morphological characteristics of reptiles.
The dataset provides detailed information about reptile species, including elevation,
seasonal precipitation, body mass, and reproductive features.
}
\examples{
data(ReptTraits)
head(ReptTraits)
}
\references{
Oskyrko, O., Mi, C., Meiri, S., & Du, W. (2024). ReptTraits: a comprehensive dataset of ecological traits in reptiles. Scientific Data, 11(1), 243.
\doi{10.1038/s41597-024-03079-5}
}
\keyword{datasets}
