% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{pop_M}
\alias{pop_M}
\title{POP-Inf M-Estimation}
\usage{
pop_M(
  X_lab = NA,
  X_unlab = NA,
  Y_lab,
  Yhat_lab,
  Yhat_unlab,
  alpha = 0.05,
  weights = NA,
  max_iterations = 100,
  convergence_threshold = 0.05,
  quant = NA,
  intercept = FALSE,
  focal_index = NA,
  method
)
}
\arguments{
\item{X_lab}{Array or DataFrame containing observed covariates in labeled data.}

\item{X_unlab}{Array or DataFrame containing observed or predicted covariates in unlabeled data.}

\item{Y_lab}{Array or DataFrame of observed outcomes in labeled data.}

\item{Yhat_lab}{Array or DataFrame of predicted outcomes in labeled data.}

\item{Yhat_unlab}{Array or DataFrame of predicted outcomes in unlabeled data.}

\item{alpha}{Specifies the confidence level as 1 - alpha for confidence intervals.}

\item{weights}{weights vector POP-Inf linear regression (d-dimensional, where d equals the number of covariates).}

\item{max_iterations}{Sets the maximum number of iterations for the optimization process to derive weights.}

\item{convergence_threshold}{Sets the convergence threshold for the optimization process to derive weights.}

\item{quant}{quantile for quantile estimation}

\item{intercept}{Boolean indicating if the input covariates' data contains the intercept (TRUE if the input data contains)}

\item{focal_index}{Identifies the focal index for variance reduction.}

\item{method}{indicates the method to be used for M-estimation. Options include "mean", "quantile", "ols", "logistic", and "poisson".}
}
\value{
A summary table presenting point estimates, standard error, confidence intervals (1 - alpha), P-values, and weights.
}
\description{
\code{pop_M} function conducts post-prediction M-Estimation.
}
\examples{
data <- sim_data()
X_lab <- data$X_lab
X_unlab <- data$X_unlab
Y_lab <- data$Y_lab
Yhat_lab <- data$Yhat_lab
Yhat_unlab <- data$Yhat_unlab
pop_M(Y_lab = Y_lab, Yhat_lab = Yhat_lab, Yhat_unlab = Yhat_unlab,
      alpha = 0.05, method = "mean")
pop_M(Y_lab = Y_lab, Yhat_lab = Yhat_lab, Yhat_unlab = Yhat_unlab,
      alpha = 0.05, quant = 0.75, method = "quantile")
pop_M(X_lab = X_lab, X_unlab = X_unlab,
      Y_lab = Y_lab, Yhat_lab = Yhat_lab, Yhat_unlab = Yhat_unlab,
      alpha = 0.05, method = "ols")
}
