% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preanalysis_functions.r
\name{checkFrequency}
\alias{checkFrequency}
\title{Check frequency table for unobserved response categories}
\usage{
checkFrequency(data)
}
\arguments{
\item{data}{a \code{\linkS4class{PROsetta_data}} object. See \code{\link{loadData}} for loading a dataset.}
}
\value{
\code{\link{checkFrequency}} returns \code{TRUE} if all response categories have a frequency of at least 1, and \code{FALSE} if not.
}
\description{
\code{\link{checkFrequency}} is a descriptive function for checking whether all response categories in a frequency table have a frequency of at least 1.
}
\examples{
checkFrequency(data_asq) # TRUE

\dontrun{
data_asq@response$EDANX01[data_asq@response$EDANX01 == 4] <- 3
checkFrequency(data_asq) # FALSE
}

}
