% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PSSM400.R
\name{pssm400}
\alias{pssm400}
\title{PSSM400 feature}
\usage{
pssm400(pssm_name)
}
\arguments{
\item{pssm_name}{name of PSSM Matrix file}
}
\value{
feature vector of length 400
}
\description{
This function firstly normalizes PSSM Matrix by formula:
\eqn{P-min(P)/max(P)-min(P)} then for any standard amino acid specifies its
position in protein sequence whereby a sub-matrix from PSSM corresponding
to these positions will be extracted, then for this sub-matrix computes
\code{\link[base]{colSums}}
of its columns to create a vector of length 20, eventually a feature vector of
length 400 will be obtained.
}
\note{
if a specific amino acid did not exist in protein then \code{\link[base]{colSums}} of whole
PSSM is computed.
}
\examples{
X<-pssm400(system.file("extdata","C7GQS7.txt.pssm",package="PSSMCOOL"))
}
