% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BradleyMSI.R
\name{BradleyMSI}
\alias{BradleyMSI}
\title{Bradley Moisture Sorption Isotherm}
\usage{
BradleyMSI(WaterAct, AdsorpM, DesorpM)
}
\arguments{
\item{WaterAct}{the numerical value of Water Activity, which ranges from 0 to 1.}

\item{AdsorpM}{the numerical value of the Moisture content of the Adsorption curve, which ranges from 0 to 1.}

\item{DesorpM}{the numerical value of the Moisture content of the Desorption curve, which ranges from 0 to 1.}
}
\value{
the nonlinear regression, parameters, and graphical visualization for the Bradley Moisture Sorption Isotherm model.
}
\description{
Bradley model is a two-parameter isotherm model that measures polar nature of sorptive surfaces.
}
\examples{
WaterAct <- c(0.1145,0.2274,0.3265,0.4291,0.6342,0.7385,0.8274,0.9573)
AdsorpM <- c(0.0234, 0.0366, 0.0496, 0.0648, 0.0887, 0.1096, 0.1343, 0.1938)
DesorpM <- c(0.0459, 0.0637, 0.0794, 0.0884, 0.1158, 0.1298,0.1500, 0.1938)
BradleyMSI(WaterAct, AdsorpM, DesorpM)
}
\references{
Bradley, R. Stevenson (1936) <doi:10.1039/JR9360001467> Polymolecular adsorbed films. Part I. The adsorption of argon on salt crystals at low temperatures, and the determination of surface fields. Journal of the Chemical Society (Resumed), (), 1467-.
}
\author{
Benz L. Rivera

John Carlo F. Panganiban

Kim M. Villacorte

Chester C. Deocaris
}
