% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loadPamguardBinaryFile.R
\name{loadPamguardBinaryFile}
\alias{loadPamguardBinaryFile}
\title{Load Pamguard Binary File}
\usage{
loadPamguardBinaryFile(
  fileName,
  skipLarge = FALSE,
  skipData = FALSE,
  debug = FALSE,
  keepUIDs = NULL,
  convertDate = FALSE,
  ...
)
}
\arguments{
\item{fileName}{The name of the binary file to be read}

\item{skipLarge}{Should we skip large parts of binaries? Currently only applicable
to whistle, click, and DIFAR data}

\item{skipData}{Should we skip all data and only read headers and footers?}

\item{debug}{logical flag to show more info on errors}

\item{keepUIDs}{If not \code{NULL}, a vector of UIDs to read. All UIDs not in this
vector will not be read.}

\item{convertDate}{logical flag to convert date from numeric to POSIXct. Defaults to 
\code{FALSE} for speed, can reduce time by}

\item{\dots}{Arguments passed to other functions}
}
\value{
This function returns a list containing two objects. Data contains
  all the binary data read. fileInfo contains metadata information for the file.
}
\description{
This function will load in the data from a Pamguard binary file. It will
  figure out the type of data being read based on the header of the file.
  All functions based on Matlab code written by Michael Oswald.
}
\examples{

# read example whistle data
wmFile <- system.file('extdata', 'WM.pgdf', package='PamBinaries')
whistleData <- loadPamguardBinaryFile(wmFile)
# works the same for different kinds of binary files
clickFile <- system.file('extdata', 'Click.pgdf', package='PamBinaries')
clickData <- loadPamguardBinaryFile(clickFile)
# convert date to POSIXct (default does not because it is faster)
clickPOSIX <- loadPamguardBinaryFile(clickFile, convertDate = TRUE)
clickData$data[[1]]$date
clickPOSIX$data[[1]]$date
# read only the fileInfo portion, has empty $data item
clickInfo <- loadPamguardBinaryFile(clickFile, skipData = TRUE)
# skip reading the large click waveforms, much faster if you dont need them
clickLess <- loadPamguardBinaryFile(clickFile, skipLarge = TRUE)
object.size(clickData)
object.size(clickLess)
# only read specific UID numbers
clickSpecific <- loadPamguardBinaryFile(clickFile, keepUIDs = c(4000006, 4000007))
names(clickSpecific$data)

}
\author{
Taiki Sakai \email{taiki.sakai@noaa.gov}
}
