% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checks.R
\name{check_balance}
\alias{check_balance}
\title{Checks the mass balance of the flows involved}
\usage{
check_balance(nodes, flows, tolerance = 0.01)
}
\arguments{
\item{nodes}{data.frame containing the nodes definition}

\item{flows}{data.frame containing the flows definition}

\item{tolerance}{numeric specifying a tolerance. Default is 0.01 (1\%)}
}
\value{
TRUE if balanced,  FALSE if not.
}
\description{
For each substance involved, the balance per (internal) node is inspected.
If outflow exceed inflow, or vice versa, a message is printed,
and the function returns FALSE.
}
\examples{
nodes <- data.frame(ID=c("A","B","C"), x=1:3, y=1:3, dir=c("right","right","stock"))
flows <- data.frame(from=c("A","B"), to=c("B","C"), quantity=c(10,10))
check_balance(nodes,flows)
}
