% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PreprocessingData.R
\name{preprocessData}
\alias{preprocessData}
\title{A function that wraps around FeatureExtraction::tidyCovariateData to normalise
the data and remove rare or redundant features}
\usage{
preprocessData(covariateData, preprocessSettings = createPreprocessSettings())
}
\arguments{
\item{covariateData}{The covariate part of the training data created by \code{splitData} after being sampled and having
any required feature engineering}

\item{preprocessSettings}{The settings for the preprocessing created by \code{createPreprocessSettings}
The data processed}
}
\value{
The covariateData object with the processed covariates
}
\description{
A function that wraps around FeatureExtraction::tidyCovariateData to normalise
the data and remove rare or redundant features
}
\details{
Returns an object of class \code{covariateData} that has been processed.
This includes normalising the data and removing rare or redundant features.
Redundant features are features that within an analysisId together cover
all obervations.
}
\examples{
library(dplyr)
data("simulationProfile")
plpData <- simulatePlpData(simulationProfile, n = 1000, seed = 42)
preProcessedData <- preprocessData(plpData$covariateData, createPreprocessSettings())
# check age is normalized by max value
preProcessedData$covariates \%>\% dplyr::filter(.data$covariateId == 1002)
}
