# PeruAPIs - Access Peruvian Data via Public APIs and Curated Datasets
# Version 0.1.0
# Copyright (c) 2025 Renzo Caceres Rossi
# Licensed under the MIT License.
# See the LICENSE file in the root directory for full license text.

#' Bird species recorded in Peru
#'
#' This dataset, birds_peru_tbl_df, is a tibble containing an updated list of bird species
#' recorded in Peru, based on the most recent taxonomic revisions by the South American
#' Checklist Committee (SACC). It provides comprehensive information about avian biodiversity
#' in Peru, including taxonomic classification, common names in English and Spanish, and
#' conservation status for each species.
#'
#' The dataset name has been kept as 'birds_peru_tbl_df' to avoid confusion with other datasets
#' in the R ecosystem. This naming convention helps distinguish this dataset as part of the
#' PeruAPIs package and assists users in identifying its specific characteristics.
#' The suffix 'tbl_df' indicates that the dataset is a tibble object. The original content has not been modified
#' in any way.
#'
#' @name birds_peru_tbl_df
#' @format A tibble with 1,914 observations and 6 variables:
#' \describe{
#'   \item{order_name}{Taxonomic order of the bird species (character)}
#'   \item{family_name}{Taxonomic family of the bird species (character)}
#'   \item{scientific_name}{Scientific name of the bird species (character)}
#'   \item{english_name}{Common name in English (character)}
#'   \item{spanish_name}{Common name in Spanish (character)}
#'   \item{status}{Conservation or taxonomic status of the species (character)}
#' }
#' @source Data taken from the \pkg{avesperu} package version 0.0.6
#' @usage data(birds_peru_tbl_df)
#' @export
load("data/birds_peru_tbl_df.rda")
NULL


#' Peruvian coastline coordinates
#'
#' This dataset, peru_coastline_df, is a data frame containing the coastline of Peru
#' represented as a spatial object. It provides geographical coordinates that define
#' the outline of Peru's Pacific coast, which can be used for mapping, spatial analysis,
#' and visualization purposes.
#'
#' The dataset name has been kept as 'peru_coastline_df' to avoid confusion with other datasets
#' in the R ecosystem. This naming convention helps distinguish this dataset as part of the
#' PeruAPIs package and assists users in identifying its specific characteristics.
#' The suffix 'df' indicates that the dataset is a data frame object. The original content has not been modified
#' in any way.
#'
#' @name peru_coastline_df
#' @format A data frame with 23,481 observations and 2 variables:
#' \describe{
#'   \item{Long}{Longitude coordinates of coastline points (numeric)}
#'   \item{Lat}{Latitude coordinates of coastline points (numeric)}
#' }
#' @source Data taken from the \pkg{Tivy} package version 0.1.1
#' @usage data(peru_coastline_df)
#' @export
load("data/peru_coastline_df.rda")
NULL


#' Peru's educational programs under ISCED classification
#'
#' This dataset, iscd_education_tbl_df, is a tibble containing Peru's educational programs
#' classified according to the International Standard Classification of Education (ISCED).
#' It provides comprehensive information about educational codes, classifications, academic levels,
#' and program specifications used in Peru's educational system, facilitating standardized
#' comparison and analysis of educational data.
#'
#' The dataset name has been kept as 'iscd_education_tbl_df' to avoid confusion with other datasets
#' in the R ecosystem. This naming convention helps distinguish this dataset as part of the
#' PeruAPIs package and assists users in identifying its specific characteristics.
#' The suffix 'tbl_df' indicates that the dataset is a tibble object. The original content has not been modified
#' in any way.
#'
#' @name iscd_education_tbl_df
#' @format A tibble with 8,357 observations and 8 variables:
#' \describe{
#'   \item{Education_COD}{Education classification code (character)}
#'   \item{Education}{Education category description (character)}
#'   \item{Specific_COD}{Specific classification code (character)}
#'   \item{Specific}{Specific category description (character)}
#'   \item{AcademicLevel}{Academic level description (character)}
#'   \item{AcademicLevel_COD}{Academic level code (character)}
#'   \item{EducationProgram}{Education program name (character)}
#'   \item{EducationProgram_Lemma}{Education program lemmatized form (character)}
#' }
#' @source Data taken from the \pkg{CINE} package version 0.1.3
#' @usage data(iscd_education_tbl_df)
#' @export
load("data/iscd_education_tbl_df.rda")
NULL

#' Peruvian Andean migrants health study
#'
#' This dataset, andean_migrants_health_df, is a data frame containing health data from
#' a random sample of Peruvians born in the Andes mountains, but who have since migrated
#' to lower altitudes. The sample was collected to assess the long-term effects of altitude
#' on blood pressure and other health indicators, providing valuable insights into the
#' physiological adaptations of high-altitude populations.
#'
#' The dataset name has been kept as 'andean_migrants_health_df' to avoid confusion with other datasets
#' in the R ecosystem. This naming convention helps distinguish this dataset as part of the
#' PeruAPIs package and assists users in identifying its specific characteristics.
#' The suffix 'df' indicates that the dataset is a data frame object. The original content has not been modified
#' in any way.
#'
#' @name andean_migrants_health_df
#' @format A data frame with 39 observations and 5 variables:
#' \describe{
#'   \item{age}{Age of the subject (integer)}
#'   \item{years}{Years since migration to lower altitude (integer)}
#'   \item{weight}{Weight of the subject (numeric)}
#'   \item{height}{Height of the subject (integer)}
#'   \item{BP}{Blood pressure measurement (integer)}
#' }
#' @source Data taken from the \pkg{s20x} package version 3.1-40
#' @usage data(andean_migrants_health_df)
#' @export
load("data/andean_migrants_health_df.rda")
NULL


#' Peru blank votes
#'
#' This dataset, peru_blank_votes_df, is a data frame containing data on the blank votes
#' in the 2006 Peruvian general election. It provides information about voting patterns
#' and their relationship with the Human Development Index (HDI), offering insights into
#' electoral behavior and socioeconomic factors in Peru's democratic process.
#'
#' The dataset name has been kept as 'peru_blank_votes_df' to avoid confusion with other datasets
#' in the R ecosystem. This naming convention helps distinguish this dataset as part of the
#' PeruAPIs package and assists users in identifying its specific characteristics.
#' The suffix 'df' indicates that the dataset is a data frame object. The original content has not been modified
#' in any way.
#'
#' @name peru_blank_votes_df
#' @format A data frame with 194 observations and 2 variables:
#' \describe{
#'   \item{votes}{Number of blank votes (numeric)}
#'   \item{HDI}{Human Development Index (numeric)}
#' }
#' @source Data taken from the \pkg{PLreg} package version 0.4.1
#' @usage data(peru_blank_votes_df)
#' @export
load("data/peru_blank_votes_df.rda")
NULL

