% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LP_modavg.R
\name{LP_modavg}
\alias{LP_modavg}
\title{Create an table of individual estimates and the model averaged values}
\usage{
LP_modavg(..., N_hat = ~1, conf_level = 0.95)
}
\arguments{
\item{...}{Series of LP fits}

\item{N_hat}{A formula requesting which abundance estimates should be formed. The formula are
expanded against the data frame to determine which records form part of the abundance estimate.
The formula is evaluated against the \code{data} frame used in the fit using the \code{model.matrix()} function,
and each column of the model
matrix is used to form an estimate.

Some familiarity on how \code{model.matrix()} generates the model matrix of coefficients used in the expansion
is needed.
For example \code{N_hat=~1} creates a model matrix with 1 column (representing the intercept) and
so requests abundance over the entire population;
Specifying \code{N_hat=~-1+Sex} creates a model matrix with 2 columns (one for each sex) consisting of 0/1 depending
if that row of the data frame is M/F. Hence, two abundance estimates (one for each sex) is computed.
On the other hand, \code{N_hat=Sex} generates a model matrix where the first column is all 1's, and
a second column which is 0/1 depending if the row in the data frame is the "second" sex. Hence, this will
request the overall abundance (over both sexes) and the estimate of abundance for the second sex.

In addition to the variables in the \code{data} frame, special variables include \code{..EF} to allow access to the expansion
factor so you can request a "truncated" Horvitz-Thompson estimator using \code{N_hat=~-1+I(as.numeric(..EF<1000))}
to only use those animals with expansion factors less than 1000 in forming the estimate.}

\item{conf_level}{The expected coverage for confidence intervals on N.}
}
\value{
An data frame with model averaged values for abundance
}
\description{
This will take a series of LP fits and computes the model averages for each set of N_hat
}
\examples{

data(data_rodli)
mt <- Petersen::LP_fit(data=data_rodli, p_model=~..time)
m0 <- Petersen::LP_fit(data=data_rodli, p_model=~1)
Petersen::LP_modavg(m0,mt)

}
