% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cap_hist_to_n_m_u.R
\name{cap_hist_to_n_m_u}
\alias{cap_hist_to_n_m_u}
\title{Convert capture history data to n, m and u for use in BTSPAS}
\usage{
cap_hist_to_n_m_u(data, sep = "..")
}
\arguments{
\item{data}{Data frame containing the variables:
\itemize{
\item \strong{cap_hist} Capture history (see details below)
\item \strong{freq} Number of times this capture history was observed
}
plus any other covariates (e.g. discrete strata and/or continuous covariates) to be used
in the model fitting.}

\item{sep}{Separator used between strata in cap_hit}
}
\value{
A list with entries for the stratum index, n (number released), m matrix
of recoveries in the current, next, etc stratum, and u (number of unmarked fish)
captured in this recovery stratum.
}
\description{
Convert capture history data to n, m and u for use in BTSPAS
}
\details{
The frequency variable (\code{freq} in the \code{data} argument) is the number of animals with the corresponding capture history.

Capture histories (\code{cap_hist} in the \code{data} argument) are character values of the format
\code{xx..yy} is a capture_history where \code{xx} and \code{yy} are the temporal stratum
(e.g., julian week) and \code{'..'} separates
the two temporal strata.
If a fish is released in temporal stratum and never captured again, then \code{yy} is set to 0;
if a fish is newly captured in temporal stratum \code{yy}, then \code{xx} is set to zero.
For example, a capture history of \code{23..23} indicates animals released in temporal stratum
23 and recaptured in temporal stratum 23; a capture history of \code{23..00}
indicates animals released in temporal stratum
23 and never seen again; a capture history of \code{00..23}
indicates animals newly captured in temporal stratum
23 at the second sampling event.

. In the diagonal case, fish are only recovered in the same temporal stratum.
In the non-diagonal case, fish are allowed to move among temporal strata.

It is not necessary to label the temporal strata starting at 1; BTSPAS will treat the smallest
value of the temporal strata seen as the first stratum and will interpolate for temporal strata
without any data. Temporal strata labels should be numeric, i.e., do NOT use A, B, C etc.
}
\examples{

data(data_btspas_diag1)
cap_hist_to_n_m_u(data_btspas_diag1)

data(data_btspas_nondiag1)
cap_hist_to_n_m_u(data_btspas_nondiag1)


}
