#' Setup Environment for PhenoSpectra
#'
#' Automatically installs and loads all required packages.
#'
#' @export
#' @return NULL. This function installs required packages if missing and loads them.
#' @examples
#' # Example usage:
#' setup_environment()  # Automatically installs and loads required packages
setup_environment <- function() {
  requiredPackages <- c("dplyr", "readxl", "writexl", "tidyr", "rlang", "magrittr", "broom", "utils")
  
  # Install missing packages
  for (pkg in requiredPackages) {
    if (!requireNamespace(pkg, quietly = TRUE)) {
      warning(paste("Package", pkg, "is not installed. Please install it manually using install.packages()."))
    }
  }
}
