% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/phytoparam.R
\name{plot.param}
\alias{plot.param}
\title{Plot relative phytosociological parameters by taxon}
\usage{
\method{plot}{param}(x, theme = "theme_classic", ...)
}
\arguments{
\item{x}{An object of class \code{param} (output of \code{\link{phytoparam}}) whose
\code{$param} data frame contains at least the columns \code{Taxon}, \code{RDe}, \code{RFr}, \code{RDo}, and \code{IV}.}

\item{theme}{A ggplot2 theme to apply. Either a character string naming a theme
constructor in \strong{ggplot2} (e.g., \code{"theme_light"}, \code{"theme_bw"}, \code{"theme_minimal"}),
or a ggplot2 theme object. Invalid inputs fall back to \code{ggplot2::theme_classic()}.}

\item{...}{Ignored.}
}
\value{
A \code{ggplot} object.
}
\description{
Produce a stacked bar chart of relative dominance (RDo), relative frequency (RFr),
and relative density (RDe) for each taxon contained in a \code{param} object returned
by \code{\link{phytoparam}}. Taxa are ordered by the Importance Value (IV).
}
\details{
The function reshapes the taxon-level table to long format and draws a
  horizontal stacked bar chart (RDo, RFr, RDe) with taxa ordered by increasing \code{IV}.
}
\examples{
res <- phytoparam(x = quadrat.df, measure.label = "CBH", taxon = "Species",
                  dead = "Morta", family = "Family", circumference = TRUE,
                  su = "Plot", height = TRUE, su.size = 25)
plot(res)                        # default theme (theme_classic)
plot(res, theme = "theme_light") # theme by name
plot(res, theme = ggplot2::theme_minimal()) # theme object

}
\seealso{
\code{\link{phytoparam}}, \code{\link{summary.param}}, and \pkg{ggplot2}.
}
