% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FunctionsPoDParameters.R
\name{PoDCurvePlot}
\alias{PoDCurvePlot}
\title{PoD curve: plot}
\usage{
PoDCurvePlot(titers,
             estimatedParameters,
             ci = 0.95)
}
\arguments{
\item{titers}{numeric vector: grid of titers at which the confidence ribbon should be calculated}

\item{estimatedParameters}{estimatedParameters named data frame (pmax, slope, et50): set of estimated PoD curve parameters, output of \code{PoDParamEstimation} function.}

\item{ci}{numeric, required confidence level}
}
\value{
PoD curve plot
}
\description{
Supplementary function for plotting the PoD curve with the confidence ribbon (of a required level). Input values are related to PoDBAY package structure. 
See \code{vignette("EfficacyEstimation", package = "PoDBAY")} for an example of application of this function.
}
\examples{
## Data preparation
library(ggplot2)
data(PoDParams)
data(estimatedParameters)

## Example 1
# titers for which we want calculate the confidence intervals
titers <- seq(from = 0, to = 15, by = 0.01)

# squared error of CurveTitersMedian and functional values of "params" curve
PoDCurvePlot(titers,
             estimatedParameters,
             ci = 0.95)

}
