\name{second_order}
\alias{second_order}
\title{Second order empirical model }
\usage{
second_order (M_infinite, K, t)
}
\arguments{
\item{M_infinite}{Total amount of drug that can be released, or the maximum drug
capacity of the system}
\item{K}{Release rate constant, which reflects how quickly the drug is being
released from the delivery system}
\item{t}{time}
}
\value{
Amount of drug released at time t Gallic Acid Equivalents per gram (GAE/gm)
}
\description{A second-order model suggests that release is governed by concentration-dependent interaction dynamics within the polymer network, providing mechanistic insight into matrix reactivity and controlled migration behaviour.

Principle:

The principle of this kinetic behaviour is concentration-dependent and may involve bimolecular interactions, such as polyphenol–polymer binding, association–dissociation equilibria, or other matrix-controlled reactive processes (Ramos et al., 2014; Malekjani et al., 2024).
}
\examples{
 second_order(0.767, 0.0164, 72)
}
\references{
Ramos, M., Beltrán, A., Peltzer, M., Valente, A. J., & del Carmen Garrigós, M. (2014). Release and antioxidant activity of carvacrol and thymol from polypropylene active packaging films. LWT-Food Science and Technology, 58(2), 470-477.

Malekjani, N., Karimi, R., Assadpour, E., & Jafari, S. M. (2024). Control of release in active packaging/coating for food products; approaches, mechanisms, profiles, and modeling. Critical reviews in food science and nutrition, 64(29), 10789-10811.
}
\keyword{second order emperical model}
