% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict_risk.R
\name{predict_10yr_ascvd_risk}
\alias{predict_10yr_ascvd_risk}
\alias{predict_10yr_cvd_risk}
\alias{predict_10yr_hf_risk}
\alias{predict_10yr_chd_risk}
\alias{predict_10yr_stroke_risk}
\alias{predict_30yr_ascvd_risk}
\alias{predict_30yr_cvd_risk}
\alias{predict_30yr_hf_risk}
\alias{predict_30yr_chd_risk}
\alias{predict_30yr_stroke_risk}
\alias{predict_5yr_ascvd_risk}
\title{CVD Risk Calculator}
\usage{
predict_10yr_ascvd_risk(
  age_years,
  race = NULL,
  sex,
  smoke_current,
  chol_total_mgdl,
  chol_hdl_mgdl,
  bp_sys_mmhg,
  bp_meds,
  statin_meds = NULL,
  diabetes,
  bmi = NULL,
  egfr_mlminm2 = NULL,
  acr = NULL,
  hba1c = NULL,
  sdi = NULL,
  equation_version = "Goff_2013",
  prevent_type = "base",
  override_boundary_errors = FALSE,
  race_levels = list(black = "black", white = "white"),
  sex_levels = list(female = "female", male = "male"),
  smoke_current_levels = list(no = "no", yes = "yes"),
  bp_meds_levels = list(no = "no", yes = "yes"),
  statin_meds_levels = list(no = "no", yes = "yes"),
  diabetes_levels = list(no = "no", yes = "yes")
)

predict_10yr_cvd_risk(
  age_years,
  race = NULL,
  sex,
  smoke_current,
  chol_total_mgdl,
  chol_hdl_mgdl,
  bp_sys_mmhg,
  bp_meds,
  statin_meds = NULL,
  diabetes,
  bmi = NULL,
  egfr_mlminm2 = NULL,
  acr = NULL,
  hba1c = NULL,
  sdi = NULL,
  equation_version = "Khan_2023",
  prevent_type = "base",
  override_boundary_errors = FALSE,
  race_levels = list(black = "black", white = "white"),
  sex_levels = list(female = "female", male = "male"),
  smoke_current_levels = list(no = "no", yes = "yes"),
  bp_meds_levels = list(no = "no", yes = "yes"),
  statin_meds_levels = list(no = "no", yes = "yes"),
  diabetes_levels = list(no = "no", yes = "yes")
)

predict_10yr_hf_risk(
  age_years,
  race = NULL,
  sex,
  smoke_current,
  chol_total_mgdl,
  chol_hdl_mgdl,
  bp_sys_mmhg,
  bp_meds,
  statin_meds = NULL,
  diabetes,
  bmi = NULL,
  egfr_mlminm2 = NULL,
  acr = NULL,
  hba1c = NULL,
  sdi = NULL,
  equation_version = "Khan_2023",
  prevent_type = "base",
  override_boundary_errors = FALSE,
  race_levels = list(black = "black", white = "white"),
  sex_levels = list(female = "female", male = "male"),
  smoke_current_levels = list(no = "no", yes = "yes"),
  bp_meds_levels = list(no = "no", yes = "yes"),
  statin_meds_levels = list(no = "no", yes = "yes"),
  diabetes_levels = list(no = "no", yes = "yes")
)

predict_10yr_chd_risk(
  age_years,
  race = NULL,
  sex,
  smoke_current,
  chol_total_mgdl,
  chol_hdl_mgdl,
  bp_sys_mmhg,
  bp_meds,
  statin_meds = NULL,
  diabetes,
  bmi = NULL,
  egfr_mlminm2 = NULL,
  acr = NULL,
  hba1c = NULL,
  sdi = NULL,
  equation_version = "Khan_2023",
  prevent_type = "base",
  override_boundary_errors = FALSE,
  race_levels = list(black = "black", white = "white"),
  sex_levels = list(female = "female", male = "male"),
  smoke_current_levels = list(no = "no", yes = "yes"),
  bp_meds_levels = list(no = "no", yes = "yes"),
  statin_meds_levels = list(no = "no", yes = "yes"),
  diabetes_levels = list(no = "no", yes = "yes")
)

predict_10yr_stroke_risk(
  age_years,
  race = NULL,
  sex,
  smoke_current,
  chol_total_mgdl,
  chol_hdl_mgdl,
  bp_sys_mmhg,
  bp_meds,
  statin_meds = NULL,
  diabetes,
  bmi = NULL,
  egfr_mlminm2 = NULL,
  acr = NULL,
  hba1c = NULL,
  sdi = NULL,
  equation_version = "Khan_2023",
  prevent_type = "base",
  override_boundary_errors = FALSE,
  race_levels = list(black = "black", white = "white"),
  sex_levels = list(female = "female", male = "male"),
  smoke_current_levels = list(no = "no", yes = "yes"),
  bp_meds_levels = list(no = "no", yes = "yes"),
  statin_meds_levels = list(no = "no", yes = "yes"),
  diabetes_levels = list(no = "no", yes = "yes")
)

predict_30yr_ascvd_risk(
  age_years,
  race = NULL,
  sex,
  smoke_current,
  chol_total_mgdl,
  chol_hdl_mgdl,
  bp_sys_mmhg,
  bp_meds,
  statin_meds = NULL,
  diabetes,
  bmi = NULL,
  egfr_mlminm2 = NULL,
  acr = NULL,
  hba1c = NULL,
  sdi = NULL,
  equation_version = "Khan_2023",
  prevent_type = "base",
  override_boundary_errors = FALSE,
  race_levels = list(black = "black", white = "white"),
  sex_levels = list(female = "female", male = "male"),
  smoke_current_levels = list(no = "no", yes = "yes"),
  bp_meds_levels = list(no = "no", yes = "yes"),
  statin_meds_levels = list(no = "no", yes = "yes"),
  diabetes_levels = list(no = "no", yes = "yes")
)

predict_30yr_cvd_risk(
  age_years,
  race = NULL,
  sex,
  smoke_current,
  chol_total_mgdl,
  chol_hdl_mgdl,
  bp_sys_mmhg,
  bp_meds,
  statin_meds = NULL,
  diabetes,
  bmi = NULL,
  egfr_mlminm2 = NULL,
  acr = NULL,
  hba1c = NULL,
  sdi = NULL,
  equation_version = "Khan_2023",
  prevent_type = "base",
  override_boundary_errors = FALSE,
  race_levels = list(black = "black", white = "white"),
  sex_levels = list(female = "female", male = "male"),
  smoke_current_levels = list(no = "no", yes = "yes"),
  bp_meds_levels = list(no = "no", yes = "yes"),
  statin_meds_levels = list(no = "no", yes = "yes"),
  diabetes_levels = list(no = "no", yes = "yes")
)

predict_30yr_hf_risk(
  age_years,
  race = NULL,
  sex,
  smoke_current,
  chol_total_mgdl,
  chol_hdl_mgdl,
  bp_sys_mmhg,
  bp_meds,
  statin_meds = NULL,
  diabetes,
  bmi = NULL,
  egfr_mlminm2 = NULL,
  acr = NULL,
  hba1c = NULL,
  sdi = NULL,
  equation_version = "Khan_2023",
  prevent_type = "base",
  override_boundary_errors = FALSE,
  race_levels = list(black = "black", white = "white"),
  sex_levels = list(female = "female", male = "male"),
  smoke_current_levels = list(no = "no", yes = "yes"),
  bp_meds_levels = list(no = "no", yes = "yes"),
  statin_meds_levels = list(no = "no", yes = "yes"),
  diabetes_levels = list(no = "no", yes = "yes")
)

predict_30yr_chd_risk(
  age_years,
  race = NULL,
  sex,
  smoke_current,
  chol_total_mgdl,
  chol_hdl_mgdl,
  bp_sys_mmhg,
  bp_meds,
  statin_meds = NULL,
  diabetes,
  bmi = NULL,
  egfr_mlminm2 = NULL,
  acr = NULL,
  hba1c = NULL,
  sdi = NULL,
  equation_version = "Khan_2023",
  prevent_type = "base",
  override_boundary_errors = FALSE,
  race_levels = list(black = "black", white = "white"),
  sex_levels = list(female = "female", male = "male"),
  smoke_current_levels = list(no = "no", yes = "yes"),
  bp_meds_levels = list(no = "no", yes = "yes"),
  statin_meds_levels = list(no = "no", yes = "yes"),
  diabetes_levels = list(no = "no", yes = "yes")
)

predict_30yr_stroke_risk(
  age_years,
  race = NULL,
  sex,
  smoke_current,
  chol_total_mgdl,
  chol_hdl_mgdl,
  bp_sys_mmhg,
  bp_meds,
  statin_meds = NULL,
  diabetes,
  bmi = NULL,
  egfr_mlminm2 = NULL,
  acr = NULL,
  hba1c = NULL,
  sdi = NULL,
  equation_version = "Khan_2023",
  prevent_type = "base",
  override_boundary_errors = FALSE,
  race_levels = list(black = "black", white = "white"),
  sex_levels = list(female = "female", male = "male"),
  smoke_current_levels = list(no = "no", yes = "yes"),
  bp_meds_levels = list(no = "no", yes = "yes"),
  statin_meds_levels = list(no = "no", yes = "yes"),
  diabetes_levels = list(no = "no", yes = "yes")
)

predict_5yr_ascvd_risk(
  age_years,
  race,
  sex,
  smoke_current,
  chol_total_mgdl,
  chol_hdl_mgdl,
  bp_sys_mmhg,
  bp_meds,
  diabetes,
  equation_version = "Goff_2013",
  override_boundary_errors = FALSE,
  race_levels = list(black = "black", white = "white"),
  sex_levels = list(female = "female", male = "male"),
  smoke_current_levels = list(no = "no", yes = "yes"),
  bp_meds_levels = list(no = "no", yes = "yes"),
  diabetes_levels = list(no = "no", yes = "yes")
)
}
\arguments{
\item{age_years}{numeric vector of age values, in years.}

\item{race}{character vector of race values. Categories should include
only 'black' or 'white'. If the race variable has additional categories
other than 'black' or 'white', then group all non 'black' values into
the 'white' category. This variable is not required if
\code{equation_version = 'Khan_2023'}}

\item{sex}{character vector of sex values. Categories should include
only 'male' or 'female'.}

\item{smoke_current}{character vector of current smoking habits. Categories
should include only 'no' and 'yes'.}

\item{chol_total_mgdl}{total cholesterol, in mg/dL.}

\item{chol_hdl_mgdl}{HDL-cholesterol, in mg/dL.}

\item{bp_sys_mmhg}{systolic blood pressure, in mm Hg.}

\item{bp_meds}{character vector of blood pressure medication use habits.
Categories should include only 'no' and 'yes'. For example, if currently
using medication to lower blood pressure, the value should be 'yes'.}

\item{statin_meds}{character vector of statin medication use habits.
Categories should include only 'no' and 'yes'. For example, if currently
using a statin, the value should be 'yes'. This variable is only
required if \code{equation_version = 'Khan_2023'}}

\item{diabetes}{character vector of diabetes status. Categories
should include only 'no' and 'yes'. For example, if diabetes is present,
the value should be 'yes'.}

\item{bmi}{numeric vector of bmi values. Only required if
\code{equation_version = "Khan_2023"}}

\item{egfr_mlminm2}{numeric vector of egfr_mlminm2 values. Only required
if \code{equation_version = "Khan_2023"}}

\item{acr}{numeric vector of acr values. Only required if
\code{equation_version = "Khan_2023"} and \code{prevent_type} is \code{"acr"} or
\code{"full"}.}

\item{hba1c}{numeric vector of hba1c values. Only required if
\code{equation_version = "Khan_2023"} and \code{prevent_type} is \code{"hba1c"} or
\code{"full"}.}

\item{sdi}{numeric vector of sdi values. Only required if
\code{equation_version = "Khan_2023"} and \code{prevent_type} is \code{"sdi"} or
\code{"full"}.}

\item{equation_version}{a character value of length 1. Valid options are
\itemize{
\item 'Goff_2013'
\item 'Yadlowsky_2018'
\item 'Khan_2023'
}

If 'Goff_2013' (the default option) is selected, the original Pooled
Cohort risk equations are used (See Goff et al., 2013).

If 'Yadlowsky_2018' is selected, the equations recommended by Yadlowsky
et al., 2018 are used.

If 'Khan_2023' is selected, the equations recommended by Khan
et al., 2023 are used.}

\item{prevent_type}{a character value of length 1. Only required if
\code{equation_version = "Khan_2023"}. Valid options are:
\itemize{
\item 'base': computes the base PREVENT equation (default).
\item 'acr': computes the PREVENT equation using albumin-to-creatinine ratio.
\item 'hba1c': computes the PREVENT equation using hemoglobin A1c.
\item 'sdi': computes the PREVENT equation using social deprivation index.
\item 'full': computes the PREVENT equation using all novel predictors.
}}

\item{override_boundary_errors}{a logical vector of length 1. If \code{FALSE}
(the default), then \code{predict_10yr_ascvd_risk()} will throw hard errors
if you give it continuous input values that are outside the bounaries
of what the Pooled Cohort risk calculator recommends. If \code{TRUE}, errors
will not be thrown. Please use with caution.}

\item{race_levels}{a list of length 2 with names 'black' and 'white'.
values in the list should be character vectors of any length, and
values in the character vectors should indicate what values in
\code{race} belong to the 'black' and 'white' categories. For example,
\code{race} may contain values of 'african_american', 'white', and
'hispanic'. In this case, \code{race_levels} should be
\code{list(white = c('white', 'hispanic'), black = 'african_american')}.}

\item{sex_levels}{a list of length 2 with names 'female' and 'male'.
values in the list should be character vectors of any length, and
values in the character vectors should indicate what values in
\code{sex} belong to the 'female' and 'male' categories (see examples).}

\item{smoke_current_levels}{a list of length 2 with names 'no' and 'yes'.
values in the list should be character vectors of any length, and
values in the character vectors should indicate what values in
\code{smoke_current} belong to the 'no' and 'yes' categories (see examples).}

\item{bp_meds_levels}{a list of length 2 with names 'no' and 'yes'.
values in the list should be character vectors of any length, and
values in the character vectors should indicate what values in
\code{bp_meds} belong to the 'no' and 'yes' categories (see examples).}

\item{statin_meds_levels}{a list of length 2 with names 'no' and 'yes'.
values in the list should be character vectors of any length, and
values in the character vectors should indicate what values in
\code{statin_meds} belong to the 'no' and 'yes' categories (see examples).}

\item{diabetes_levels}{a list of length 2 with names 'no' and 'yes'.
values in the list should be character vectors of any length, and
values in the character vectors should indicate what values in
\code{diabetes} belong to the 'no' and 'yes' categories (see examples).}
}
\value{
a numeric vector with 10-year predicted risk values for ASCVD events.
}
\description{
This function implements
\itemize{
\item the Pooled Cohort Risk equations from Goff et al, 2013.
\item the updated Pooled Cohort Risk equations from Yadlowski et al, 2018
\item The PREVENT equations from Khan et al, 2023
}

These equations predict 10-year risk of a first atherosclerotic
cardiovascular disease (ASCVD) event, such as a stroke or myocardial
infarction. The 2017 American College of Cardiology and American Heart
Association blood pressure guideline recommends using 10-year predicted
atherosclerotic cardiovascular disease risk to guide the decision to
initiate or intensify antihypertensive medication. The guideline recommends
using the Pooled Cohort risk prediction equations to predict 10-year
atherosclerotic cardiovascular disease risk in clinical practice.
}
\details{
The 2017 American College of Cardiology (ACC) / American Heart
Association (AHA) blood pressure (BP) guideline recommends using 10-year
predicted atherosclerotic cardiovascular disease (ASCVD) risk to guide
the decision to initiate antihypertensive medication. The guideline
recommends using the Pooled Cohort risk prediction equations (Goff et al, 2013)
to predict 10-year ASCVD risk. The Pooled Cohort risk prediction equations
have been externally validated in several studies and, in some populations,
are known to overestimate 10-year ASCVD risk. In 2018, an updated set of
equations were developed by Yadlowsky et al. using more contemporary data
and statistical methods.
}
\examples{

# example taken from Goff et al, 2013

sex = c('female', 'female', 'male', 'male')
race = c('black', 'white', 'black', 'white')
# 55 years of age
age_years = rep(55, times = 4)
# total cholesterol 213 mg/dL
chol_total_mgdl = rep(213, times = 4)
# HDL cholesterol 50 mg/dL
chol_hdl_mgdl = rep(50, times = 4)
# untreated systolic BP 120 mm Hg
bp_sys_mmhg = rep(120, times = 4)
bp_meds = rep('no', times = 4)
# nonsmoker
smoke_current = rep('no', times = 4)
# without diabetes
diabetes = rep('no', times = 4)

pcr_probs <- predict_10yr_ascvd_risk(
  sex = sex,
  race = race,
  age_years = age_years,
  chol_total_mgdl = chol_total_mgdl,
  chol_hdl_mgdl = chol_hdl_mgdl,
  bp_sys_mmhg = bp_sys_mmhg,
  bp_meds = bp_meds,
  smoke_current = smoke_current,
  diabetes = diabetes
)

# note that this isn't an exact match of Table 4 in
# Goff et al supplement - this is because the table's
# coefficients are rounded to a lower decimal count than
# the coefficients used in predict_10yr_ascvd_risk()
round(100 * pcr_probs, 1)

# using a data frame with more granular categories and names

some_data <- data.frame(
  gender = c('woman', 'woman', 'man', 'male'),
  race_3cats = c('AA', 'white', 'AA', 'other'),
  # 55 years of age
  age_years = rep(55, times = 4),
  # total cholesterol 213 mg/dL
  chol_total_mgdl = rep(213, times = 4),
  # HDL cholesterol 50 mg/dL
  chol_hdl_mgdl = rep(50, times = 4),
  # untreated systolic BP 120 mm Hg
  bp_sys_mmhg = rep(120, times = 4),
  bp_meds = rep('No', times = 4),
  # nonsmoker
  smoke_current = c("no", "former", "no", "never"),
  # without diabetes
  diabetes = rep('No', times = 4),
  stringsAsFactors = FALSE
)

pcr_probs <- with(
  some_data,
  predict_10yr_ascvd_risk(
    sex = gender,
    sex_levels = list(female = 'woman', male = c('man', 'male')),
    race = race_3cats,
    age_years = age_years,
    chol_total_mgdl = chol_total_mgdl,
    chol_hdl_mgdl = chol_hdl_mgdl,
    bp_sys_mmhg = bp_sys_mmhg,
    bp_meds = bp_meds,
    smoke_current = smoke_current,
    diabetes = diabetes,
    race_levels = list(black = 'AA', white = c('white', 'other')),
    smoke_current_levels = list(no = c('no', 'former', 'never'), yes = 'Yes'),
    bp_meds_levels = list(no = 'No', yes = 'Yes'),
    diabetes_levels = list(no = 'No', yes = 'Yes')
  )
)


}
\references{
Goff DC, Lloyd-Jones DM, Bennett G, Coady S, D’agostino RB,
Gibbons R, Greenland P, Lackland DT, Levy D, O’donnell CJ, Robinson JG.
2013 ACC/AHA guideline on the assessment of cardiovascular risk: a report
of the American College of Cardiology/American Heart Association Task
Force on Practice Guidelines. \emph{Journal of the American College of Cardiology}.
2014 Jul 1;63(25 Part B):2935-59. DOI: 10.1016/j.jacc.2014.03.006

Yadlowsky S, Hayward RA, Sussman JB, McClelland RL, Min YI, Basu S.
Clinical implications of revised pooled cohort equations for estimating
atherosclerotic cardiovascular disease risk. \emph{Annals of internal medicine}.
2018 Jul 3;169(1):20-9. DOI: 10.7326/M17-3011

Khan SS, Coresh J, Pencina MJ, Ndumele CE, Rangaswami J, Chow SL,
Palaniappan LP, Sperling LS, Virani SS, Ho JE, Neeland IJ, Tuttle KR,
Rajgopal Singh R, Elkind MSV, Lloyd-Jones DM; American Heart Association.
Novel Prediction Equations for Absolute Risk Assessment of Total
Cardiovascular Disease Incorporating Cardiovascular-Kidney-Metabolic
Health: A Scientific Statement From the American Heart Association.
\emph{Circulation}. 2023 Dec 12;148(24):1982-2004. PMID: 37947094.
}
