% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interdiff.R
\name{interdiff}
\alias{interdiff}
\title{Interpolate ages from age group medians}
\usage{
interdiff(nodes, pplage, pplprop, endmin, endmax, grpdef)
}
\arguments{
\item{nodes}{A data frame containing all grouping variables, the node ages for each group, and the associated node values.}

\item{pplage}{The variable containing the node ages.}

\item{pplprop}{The variable containing the node values.}

\item{endmin}{The variable that contains the minimum age for each group.}

\item{endmax}{The variable that contains the maximum age for each group.}

\item{grpdef}{A character vector containing the names of the grouping variables.}
}
\value{
A data frame containing the fitted values, by age within group.
}
\description{
The node ages for each age group are defined by the user, along with the age group values. The ages are then imputed from these nodes.
Zero values at both extremes must be included. For example, for the age group 20-24 years, the pplprop value is for pplage. if the first non-zero relationship probability is for the age group 20-24 years, and the previous age group is 15-19 years, pplprop==0 for pplage==19.
For each age group, there must be a minimum and maximum age specified. This provides the interpolation range for each age group. For the anchoring 0 values, the minimum and maximum ages are the same. In this example, for pplage==19, endmin==19, and endmax==19.
If there is no zero for older ages, as the final node value occurs inside the age group, the function assumes that the last node-to-node should be used to extrapolate for the ages older than the oldest node value. For example, if the last node value is for 90 years of age, but the oldest age is 95 years, the function will assume the same slope for ages 91 through 95 years.
The function can perform a separate interpolation for groups, for example, a separate interpolation can be performed for each sex. The function is flexible for the number of variables that can be used to define groups. If only one interpolation is required, the same grpdef value should be used for each row in the data frame.
}
\details{
While the function is designed to interpolate proportions, in practice it can interpolate any values. The limitation is that the function performs no rounding. Integer node values may produce non-integer estimates.
}
\examples{

library("dplyr")

# create the expected proportion of people in relationships, by age within sex
thegroups <- as.vector("Sex")
RelProps <- interdiff(GroupInfo, pplage = "MidPoints", pplprop = "RelProps", endmin = "MinAge",
                      endmax = "MaxAge", grpdef = thegroups)
}
