% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/constraints.R
\name{turnover_constraint}
\alias{turnover_constraint}
\title{constructor for turnover_constraint}
\usage{
turnover_constraint(
  type = "turnover",
  turnover_target,
  turnover_penalty = NULL,
  weight_initial = NULL,
  enabled = TRUE,
  message = FALSE,
  ...
)
}
\arguments{
\item{type}{character type of the constraint}

\item{turnover_target}{target turnover value}

\item{turnover_penalty}{optional penalty parameter for turnover constraint}

\item{weight_initial}{optional initial weights vector to compute turnover from}

\item{enabled}{TRUE/FALSE}

\item{message}{TRUE/FALSE. The default is message=FALSE. Display messages if TRUE.}

\item{\dots}{any other passthru parameters to specify box and/or group constraints}
}
\value{
an object of class 'turnover_constraint'
}
\description{
The turnover constraint specifies a target turnover value. 
This function is called by add.constraint when type="turnover" is specified, see \code{\link{add.constraint}}.
Turnover is calculated from a set of initial weights. Turnover is 
computed as \code{sum(abs(initial_weights - weights)) / N} where \code{N} is
the number of assets.
}
\details{
Note that with the ROI solvers, turnover constraint is currently only 
supported for the global minimum variance and quadratic utility problems 
with ROI quadprog plugin.
}
\examples{
data(edhec)
ret <- edhec[, 1:4]

pspec <- portfolio.spec(assets=colnames(ret))

pspec <- add.constraint(portfolio=pspec, type="turnover", turnover_target=0.6)
}
\seealso{
\code{\link{add.constraint}}
}
\author{
Ross Bennett
}
