% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{fit_model_q}
\alias{fit_model_q}
\title{Fit OLS model using lm.fit (Internal Helper)}
\usage{
fit_model_q(X_full, y, q_indices)
}
\arguments{
\item{X_full}{Numeric matrix. Full design matrix including intercept if present.
Column names must be unique. Typically derived from \code{X} + intercept inside \code{simultaneous_ci()}.}

\item{y}{Numeric vector. Response variable, same length as \code{nrow(X_full)}.}

\item{q_indices}{Integer vector. Column indices (1-based) specifying the submodel to fit.}
}
\value{
Named numeric vector of estimated coefficients. If fitting fails or coefficients
are dropped due to collinearity, NA values are returned with expected names.
}
\description{
Lightweight and robust wrapper around \code{lm.fit()} for use in bootstrap procedures.
Designed to handle possible rank-deficiency gracefully by returning NA-coefficients
for linearly dependent terms. Primarily used internally within \code{simultaneous_ci()}.
}
\keyword{internal}
