% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_documentation.R
\docType{data}
\name{group_cog_data}
\alias{group_cog_data}
\title{Group Cognitive Data}
\format{
A data frame with 20 rows and 20 variables:
\describe{
\item{group.factor}{A factor indicating group membership: \code{Control} or \code{ESKD} (End-Stage Kidney Disease).}
\item{mean_suv}{A numeric vector representing the mean SUV (Standard Uptake Value).}
\item{blind_moca_uncorrected}{A numeric vector representing uncorrected MOCA (Montreal Cognitive Assessment) scores.}
\item{craft_verbatim}{A numeric vector representing scores on the Craft Verbatim memory test.}
\item{craft_delay_verbatim}{A numeric vector representing delayed scores on the Craft Verbatim memory test.}
\item{number_span_forward}{A numeric vector representing forward number span scores.}
\item{number_span_backward}{A numeric vector representing backward number span scores.}
\item{fluency_f_words_correct}{A numeric vector representing the number of correct F words in a verbal fluency test.}
\item{oral_trail_part_a}{A numeric vector representing scores on the oral trail making test part A.}
\item{oral_trail_part_b}{A numeric vector representing scores on the oral trail making test part B.}
\item{fluency_animals}{A numeric vector representing the number of animal names listed in a verbal fluency test.}
\item{fluency_vegetables}{A numeric vector representing the number of vegetable names listed in a verbal fluency test.}
\item{verbal_naming_no_cue}{A numeric vector representing scores on a verbal naming test without cues.}
\item{age}{A numeric vector representing the age of each subject.}
}
}
\usage{
group_cog_data
}
\description{
A dataset representing cognitive scores for control and treatment groups, with various cognitive and demographic variables.
}
\examples{
data(group_cog_data)
head(group_cog_data)
}
\keyword{datasets}
