## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----tab-dif, echo=FALSE, message=FALSE, warning=FALSE------------------------
library(kableExtra)
load("../tests/testthat/_openmpt/testcasestate.Rdata")
testresult <- table(openmpt_testfiles$state)

## ----diffs, message=FALSE-----------------------------------------------------
library(ProTrackR)
library(ProTrackR2)

## *Old* way of creating a blank module:
mod_old <- new("PTModule")
## *New* way of creating a blank module:
mod_new <- pt2_new_mod("my mod")

## *Old* reading a module:
## Note that `ProTrackR` does not support compressed modules,
## so we first need to create a file that the old library can read:
file_decompressed <- tempfile()
pt2_write_mod(pt2_read_mod(pt2_demo()), file_decompressed)
## Now the old library can actually read it
mod_old <- read.module(file_decompressed)
## *New* way of creating a blank module:
mod_new <- pt2_read_mod(pt2_demo())

## *Old* way of getting a sample
samp_old <- PTSample(mod_old, 1L)
## *New* way of getting a sample
samp_new <- mod_new$samples[[1L]]

## *Old* way of getting a pattern
patt_old <- PTPattern(mod_old, 1L)
## *New* way of getting a pattern
patt_new <- mod_new$patterns[[1L]]

## *Old* way of getting a cell
cell_old <- PTCell(mod_old, 1L, 1L, 1L)
## *New* way of getting a cell
##
##   First cell in cell-list ---------------+
##   First column in pattern ----------+    |
##      First row in pattern ------+   |    |
##             First pattern -+    |   |    |
##                            |    |   |    |
##                            V    V   V    V
cell_new <- mod_new$patterns[[1L]][1L, 1L][[1L]]

print(cell_old)
print(cell_new)

## ----audio-tuner, eval=FALSE--------------------------------------------------
# ## Load demo module
# mod <- pt2_read_mod(pt2_demo())
# 
# ## render 'audioSample' object
# mod_audio <- pt2_render(mod)
# 
# ## Convert from 'audio::audioSample' to 'tuneR::Wave' object:
# if (requireNamespace("tuneR")) {
#   mod_tuneR <-
#     tuneR::Wave(
#       left      = as.integer(2^15*unclass(mod_audio[1,])),
#       right     = as.integer(2^15*unclass(mod_audio[2,])),
#       samp.rate = attributes(mod_audio)$rate,
#       bit       = attributes(mod_audio)$bits
#     )
# }

