## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----setup--------------------------------------------------------------------
library(ProfileGLMM)
data("exposure_data")
exp_data = exposure_data$df
head(exp_data)

## -----------------------------------------------------------------------------
covList = {}
covList$FE = c('X')

covList$RE = c('t')
covList$REunit = c('indiv')

covList$Lat = c('X')

covList$Assign$Cont = c('Exp1','Exp2')
covList$Assign$Cat = NULL

covList$Y = c('Y')
dataProfile = profileGLMM_preprocess(regType = 'linear',
                                     covList = covList,
                                     dataframe = exp_data,
                                     nC = 30,
                                     intercept = list(FE = T, RE = F, Lat = T))
print(dataProfile)

## -----------------------------------------------------------------------------
MCMC_Obj = profileGLMM_Gibbs(model = dataProfile,
                             nIt = 5000,
                             nBurnIn = 2000)

## -----------------------------------------------------------------------------
par(mfrow = c(1,2), col.sub="blue", cex.sub=2)
plot(MCMC_Obj$zeta,ylab = 'zeta',xlab = 'samples')
plot(MCMC_Obj$beta[1,],ylab = 'beta_1',xlab = 'samples')

## -----------------------------------------------------------------------------
post_Obj = profileGLMM_postProcess(MCMC_Obj)
#Fixed effects estimates
summary(post_Obj)

## -----------------------------------------------------------------------------
plot(post_Obj,color = hcl.colors(9, palette = "Set 2"))

## -----------------------------------------------------------------------------
pred = predict(post_Obj,dataProfile$d) 
table(pred$classPred,exposure_data$theta0$Lat)

