% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots-standard_curve.R
\name{plot_standard_curve_stacked}
\alias{plot_standard_curve_stacked}
\title{Standard curve stacked plot for levey-jennings report}
\usage{
plot_standard_curve_stacked(
  list_of_plates,
  analyte_name,
  data_type = "Median",
  decreasing_dilution_order = TRUE,
  monochromatic = TRUE,
  legend_type = NULL,
  log_scale = c("all"),
  verbose = TRUE
)
}
\arguments{
\item{list_of_plates}{list of Plate objects}

\item{analyte_name}{Name of the analyte of which standard curves we want to plot.}

\item{data_type}{Data type of the value we want to plot - the same
datatype as in the plate file. By default equals to \code{Median}}

\item{decreasing_dilution_order}{If \code{TRUE} the dilution values are
plotted in decreasing order, \code{TRUE} by default}

\item{monochromatic}{If \code{TRUE} the color of standard curves changes
from white (the oldest) to blue (the newest) it helps to observe drift in
calibration of the device; otherwise, more varied colours are used, \code{TRUE} by default}

\item{legend_type}{default value is \code{NULL}, then legend type is determined
based on monochromatic value. If monochromatic is equal to \code{TRUE} then legend
type is set to \code{date}, if it is \code{FALSE} then legend
type is set to \code{plate_name}. User can override this behavior by
setting explicitly \code{legend_type} to \code{date} or \code{plate_name}.}

\item{log_scale}{Which elements on the plot should be displayed in log scale.
By default \code{"all"}. If \code{NULL} or \code{c()} no log scale is used,
if \code{"all"} or \code{c("dilutions", "MFI")} all elements are displayed in log scale.}

\item{verbose}{If \code{TRUE} prints messages, \code{TRUE} by default}
}
\value{
ggplot object with the plot
}
\description{
Function generates a plot of stacked on top of each other standard curves
for a given analyte form a list of plates. The plot is created with the
levey-jennings report in mind, but it can be run by itself.
}
\examples{

# creating temporary directory for the example
output_dir <- tempdir(check = TRUE)

dir_with_luminex_files <- system.file("extdata", "multiplate_reallife_reduced",
  package = "PvSTATEM", mustWork = TRUE
)
list_of_plates <- process_dir(dir_with_luminex_files,
  return_plates = TRUE, format = "xPONENT", output_dir = output_dir
)
plot_standard_curve_stacked(list_of_plates, "ME", data_type = "Median", monochromatic = FALSE)

}
