% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/boolean.R
\name{evaluate_dnf}
\alias{evaluate_dnf}
\title{Evaluate a formula}
\usage{
evaluate_dnf(data, formula)
}
\arguments{
\item{data}{A data frame where the rows represent cases and the columns the sets. Column names must be as in the formula.}

\item{formula}{A string, list of strings or function representing a Boolean formula in disjunctive normal form}
}
\value{
the fuzzy set score of the set described by the formula for each case in the data
}
\description{
When given a Boolean formula (see details) and a \code{data.frame} of cases and fuzzy
set score for conditions, computes for each case the score of the membership
in the set described by the formula
}
\details{
If \code{formula} is a function, it must take a \code{data.frame} and return
a vector.

If \code{formula} is a string or list of strings, the following conventions hold:
Set names must be capitalized in the formula and the data; if they are
lowercase, they are interpreted as the negation of the set.
If \code{formula} is a string, logical 'or' is expressed as a '+',
and logical 'and' as a '*'.
If \code{formula} is a list of strings, the strings are assumed to be
the dosjuncts and are concatenated with '+'.
The formula must be in disjunctive normal form, i.e. it must be a disjunction of
conjunctions of elementary or negated elementary sets. Example:
\code{A*b*C + a*B}
}
\examples{
require(QCA)
data(d.urban)
evaluate_dnf(d.urban, "MLC*frb + CP")

}

