% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/Lookback.R
\name{LookbackMC}
\alias{LookbackMC}
\title{Lookback option valuation via Monte Carlo (MC) simulation}
\usage{
LookbackMC(o = OptPx(Opt(Style = "Lookback"), r = 0.05, q = 0, vol = 0.3),
  NPaths = 5, div = 1000, Type = c("Floating", "Fixed"))
}
\arguments{
\item{o}{The \code{OptPx} option object to price. See \code{OptPx} and \code{Opt} for more information.}

\item{NPaths}{How many time of the simulation are applied. Coustomer defined.}

\item{div}{number to decide length of each interval}

\item{Type}{Specifies the Lookback option as either Floating or Fixed- default argument is Floating.}
}
\value{
A list of class \code{LookbackMC} consisting of the input object \code{OptPx} and the price of the lookback option based on Monte Carlo Simulation (see references).
}
\description{
Calculates the price of a lookback option using a Monte Carlo (MC) Simulation.
Carries the assumption that the asset price is observed continuously.
Assumes that the the option o followes ds = mu * S * dt + sqrt(vol) * S * dz
where dz is a Wiener Process. Assume that without dividends, mu are default to be r.
}
\details{
To price the lookback option, we require the S0, K, and ttm arguments from object \code{Opt}
and r, q, vol from object OptPx defined in the package. The results of simulation would
unstable without setting seeds.
}
\examples{
(o = LookbackMC())$PxMC   #Use default arguments, Output: approximately 16.31.

 # Floating & Put
 o=OptPx(Opt(S0=50,K=50,ttm=0.25,Right='Put',Style="Lookback"),r=0.1,vol=.4)
 LookbackMC(o,NPaths=5,div=1000) #Output: 7.79 from Hull 9e Example 26.2 Pg 608.

 # Floating & Call
 o=OptPx(Opt(S0=50,K=50,ttm=0.25,Right='Call',Style="Lookback"),r=0.1,vol=.4)
 LookbackMC(o,NPaths=5,div=1000) #Output: 8.04 from Hull 9e Example 26.2 Pg 608

 # Fixed & Put
 o=OptPx(Opt(S0=50,K=60,ttm=1,Right='Put',Style="Lookback"),r=0.05,q=0.02,vol=.25)
 LookbackMC(o,Type="Fixed",NPaths=5,div=1000)

 # Fixed & Call
 o=OptPx(Opt(S0=50,K=55,ttm=1,Right='Call',Style="Lookback"),r=0.1,vol=.25)
 LookbackMC(o,Type="Fixed",NPaths=5,div=1000)
}
\author{
Tong Liu, Department of Statistics, Rice University, Spring 2015
}
\references{
Hull, John C., \emph{Options, Futures and Other Derivatives}, 9ed, 2014. Prentice Hall.
 ISBN 978-0-13-345631-8, \url{http://www-2.rotman.utoronto.ca/~hull/ofod}
}

