% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dq.R
\name{dq}
\alias{dq}
\title{Sequential Determination of the Number of Breaks Using the DQ Test}
\usage{
dq(
  y,
  x,
  vec.tau,
  q.L,
  q.R,
  n.size = 1,
  m.max,
  trim.size,
  mat.date,
  d.Sym,
  table.cv
)
}
\arguments{
\item{y}{A numeric vector of dependent variables (\eqn{NT \times 1}).}

\item{x}{A numeric matrix of regressors (\eqn{NT \times p}).}

\item{vec.tau}{A numeric vector of quantiles of interest.}

\item{q.L}{A numeric value specifying the left-end quantile range for the DQ test.}

\item{q.R}{A numeric value specifying the right-end quantile range for the DQ test.}

\item{n.size}{An integer specifying the size of the cross-section (\eqn{N}).}

\item{m.max}{An integer indicating the maximum number of breaks allowed.}

\item{trim.size}{A numeric trimming value (the minimum length of a regime).}

\item{mat.date}{A numeric matrix of break dates.}

\item{d.Sym}{A logical value indicating whether the quantile range is symmetric satisfying \eqn{q.R=1-q.L}.}

\item{table.cv}{A matrix of simulated critical values for cases not covered by the response surface.}
}
\value{
A list containing:
\describe{
\item{\code{test}}{A numeric vector of DQ test statistics.}
\item{\code{cv}}{A numeric matrix of critical values for the DQ test at 10, 5, and 1 percent significance levels.}
\item{\code{date}}{A numeric matrix of estimated break dates.}
\item{\code{nbreak}}{A numeric vector indicating the number of detected breaks at different significance levels.}
}
}
\description{
This function determines the number of breaks in a model by
sequentially applying the DQ(\eqn{l | l+1}) test. It tests for additional breaks
by comparing the test statistic to critical values at various significance levels.
}
\examples{

\donttest{
# This example may take substantial time for automated package 
# checks since it involves dynamic programming
data(gdp)
y = gdp$gdp
x = gdp[,c("lag1", "lag2")]
n.size = 1
T.size = length(y) # number of time periods

# setting
vec.tau   = seq(0.20, 0.80, by = 0.150)
trim.e    = 0.2
trim.size = round(T.size * trim.e)  #minimum length of a regime
m.max     = 3

# dynamic program algorithm to compute the objective function
out.long   = gen.long(y, x, vec.tau, n.size, trim.size)
mat.long.s = out.long$mat.long  ## for break estimation using individual quantile
vec.long.m = out.long$vec.long  ## for break estimation using multiple quantiles jointly

# break date
mat.date = brdate(y, x, n.size, m.max, trim.size, vec.long.m)

## qunatile ranges (left and right)
q.L   = 0.2
q.R   = 0.8
d.Sym = TRUE ## symmetric trimming of quantiles
table.cv = NULL ##covered by the response surface because d.Sym = TRUE

# determine the number of breaks
out.m = dq(y, x, vec.tau, q.L, q.R, n.size, m.max, trim.size, mat.date, d.Sym, table.cv)

# result
print(out.m)
}


}
