% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IPWE_Qopt_DepCen_general.R
\name{IPWE_Qopt_DepCen_general}
\alias{IPWE_Qopt_DepCen_general}
\title{Estimate Quantile-optimal Treatment Regime for covariates-dependent random censoring data}
\usage{
IPWE_Qopt_DepCen_general(data, regimeClass, tau, Domains = NULL, bw,
  moPropen = "BinaryRandom", DepCens = NULL, UseTrueG = FALSE,
  trueG_value = NULL, cluster = FALSE, p_level = 1, s.tol = 1e-05,
  it.num = 8, pop.size = 5000)
}
\arguments{
\item{data}{raw data.frame}

\item{regimeClass}{the class of treatment regimes. e.g., 'txname ~ x1+x2'.}

\item{tau}{the quantile of interest}

\item{Domains}{default is NULL.}

\item{bw}{the bandwidth of local KM model (e.g. see Wang-wang 2008)}

\item{moPropen}{an optional string for the working model of treatment assignment}

\item{DepCens}{an optional vector of baseline variable names that the censoring variable 
depends on. Note that
the treatment variable is always treated as dependent with the censoring time. 
If unspecified (\code{DepCens=NULL}), then all variables on the right side of 
\code{regimeClass} are used for \code{DepCens}}

\item{UseTrueG}{logical. Whether the true survival probability of each patient is provided.}

\item{trueG_value}{default is NULL. 
IF \code{UseTrueG=FALSE}, \code{trueG_value} should be \code{NULL}.}

\item{cluster}{default is FALSE. This can also be an object of the 'cluster' class 
returned by one of the makeCluster commands in the parallel package or
 a vector of machine names so rgenoud::genoud can setup the cluster automatically.}

\item{p_level}{print level}

\item{s.tol}{tolerance level}

\item{it.num}{the maximum iteration number}

\item{pop.size}{the initial population size}
}
\description{
This function estimates the Quantile-optimal Treatment Regime 
for a given quantile level of interest
under the
assumption that the distribution of censoring time is independent of the set of potential
survival times given a set of baseline covariates and treatment actually received.

More specifically, we do stratification by treatment first and then
 used kernel smoothing to estimate local survival function of censoring time
 for each treatment group.
}
\examples{
GenerateData <- function(n)
{
  x1 <- runif(n, min=-0.5,max=0.5)
  x2 <- runif(n, min=-0.5,max=0.5)
  error <- rnorm(n, sd= 1)
  ph <- exp(-0.5+1*(x1+x2))/(1+exp(-0.5 + 1*(x1+x2)))
  a <- rbinom(n = n, size = 1, prob=ph)
  c <- 1.5 +  + runif(n = n, min=0, max=2)
  cmplt_y <-  pmin(2+x1+x2 +  a*(1 - x1 - x2) +  (0.2 + a*(1+x1+x2)) * error, 4.4)
  censor_y <- pmin(cmplt_y, c)
  delta <- as.numeric(c > cmplt_y)
  return(data.frame(x1=x1,x2=x2,a=a, censor_y = censor_y, delta=delta))
}

\dontshow{
data <- GenerateData(50)
fit2 <- IPWE_Qopt_DepCen_general(data = data, regimeClass = a~x1+x2, moPropen = a~x1+x2,
                                 tau = 0.2, bw = 20/50, 
                                 pop.size=300, it.num = 3)
}                        
          
\donttest{
n <- 400
data <- GenerateData(n)
fit1 <- IPWE_Qopt_DepCen_general(data = data, regimeClass = a~x1+x2, moPropen = a~x1+x2,
                                 tau = 0.2, bw = 20/n, 
                                 pop.size=3000, it.num = 3)
                                 }
}
