% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/standardization.R
\name{rm_outlier}
\alias{rm_outlier}
\title{Identify and Remove Outliers Based on Bonferroni-Holm Adjusted P-values}
\usage{
rm_outlier(data, alpha = 0.05)
}
\arguments{
\item{data}{A data.frame containing a `theta` column.
This is usually a subset of the full dataset, representing samples within a single genotype class.}

\item{alpha}{Significance level for identifying outliers (default is `0.05`).
Observations with adjusted p-values below this threshold will be removed.}
}
\value{
A data.frame containing only the non-outlier observations from the input.
  If fewer than two non-NA `theta` values are present or if all values are identical,
  the input is returned unmodified.
}
\description{
This function detects and removes outlier observations from a vector of `theta` values
using externally studentized residuals and the Bonferroni-Holm adjustment for multiple testing.
It is typically used during genotype cluster center estimation to clean noisy values.
}
\details{
The method fits a constant model (`theta ~ 1`) and computes standardized residuals.
Observations with significant deviation are flagged using the Bonferroni-Holm procedure
and removed if their adjusted p-value is below the defined `alpha` threshold.

This function was originally developed by **Kaio Olympio** and incorporated into the Qploidy workflow.
}
\author{
Kaio Olympio
}
