% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate_inputs.R
\name{simulate_standardization_input}
\alias{simulate_standardization_input}
\title{Simulate Genotyping Data with Flexible Ploidy}
\usage{
simulate_standardization_input(
  n_markers = 10,
  n_samples = 5,
  ploidy = 2,
  seed = 2025
)
}
\arguments{
\item{n_markers}{Integer. Number of markers to simulate (default: 10).}

\item{n_samples}{Integer. Number of individuals/samples to simulate (default: 5).}

\item{ploidy}{Integer. Ploidy level of the organism (e.g., 2 for diploid, 4 for tetraploid).}

\item{seed}{Integer. Random seed for reproducibility (default: 2025).}
}
\value{
A named list with:
\describe{
  \item{sample_data}{Allelic signal intensities (X, Y, R, ratio).}
  \item{geno_data}{Genotype dosage and probability data.}
  \item{geno_pos}{Genomic coordinates for each marker.}
  \item{standardization_input}{Merged input data with theta and genotype.}
}
}
\description{
Generates synthetic genotyping and signal intensity data for a given ploidy level.
Returns a structured list containing input data suitable for standardization analysis.
}
