% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/standardization.R
\name{standardize}
\alias{standardize}
\title{Standardize Allelic Ratio Data and Compute BAF and Z-Scores}
\usage{
standardize(
  data = NULL,
  genos = NULL,
  geno.pos = NULL,
  threshold.missing.geno = 0.9,
  threshold.geno.prob = 0.8,
  ploidy.standardization = NULL,
  threshold.n.clusters = NULL,
  n.cores = 1,
  out_filename = NULL,
  type = "intensities",
  multidog_obj = NULL,
  parallel.type = "PSOCK",
  verbose = TRUE,
  rm_outlier = TRUE,
  cluster_median = TRUE
)
}
\arguments{
\item{data}{A `data.frame` containing the full dataset with the following columns:
\describe{
  \item{MarkerName}{Marker identifiers.}
  \item{SampleName}{Sample identifiers.}
  \item{X}{Reference allele intensity or count.}
  \item{Y}{Alternative allele intensity or count.}
  \item{R}{Total signal intensity or read depth (X + Y).}
  \item{ratio}{Allelic ratio, typically Y / (X + Y).}
}}

\item{genos}{A `data.frame` containing genotype dosage information for the reference panel.
This should include samples of known ploidy and ideally euploid individuals.
Required columns:
\describe{
  \item{MarkerName}{Marker identifiers.}
  \item{SampleName}{Sample identifiers.}
  \item{geno}{Estimated dosage (0, 1, 2, ...).}
  \item{prob}{Genotype call probability (used for filtering low-confidence genotypes).}
}}

\item{geno.pos}{A `data.frame` with marker position metadata. Required columns:
\describe{
  \item{MarkerName}{Marker identifiers.}
  \item{Chromosome}{Chromosome names.}
  \item{Position}{Base-pair positions on the genome.}
}}

\item{threshold.missing.geno}{Numeric (0–1). Maximum fraction of missing genotype data allowed per marker.
Markers with a higher fraction will be removed.}

\item{threshold.geno.prob}{Numeric (0–1). Minimum genotype call probability threshold.
Genotypes with lower probability will be treated as missing.}

\item{ploidy.standardization}{Integer. The ploidy level of the reference panel used for standardization.}

\item{threshold.n.clusters}{Integer. Minimum number of expected dosage clusters per marker.
For diploid data, this is typically 3 (corresponding to genotypes 0, 1, and 2).}

\item{n.cores}{Integer. Number of cores to use in parallel computations (e.g., for cluster center estimation and BAF generation).}

\item{out_filename}{Optional. Path to save the final standardized dataset to disk as a CSV file (suitable for Qploidy).}

\item{type}{Character. Type of data used for clustering:
\describe{
  \item{"intensities"}{For array-based allele intensity data.}
  \item{"counts"}{For sequencing data.}
  \item{"updog"}{Automatically set when `multidog_obj` is provided.}
}}

\item{multidog_obj}{Optional. An object of class `multidog` from the `updog` package, containing model fits and estimated biases.
If provided, this will override the `type` parameter and use `updog`'s expected cluster positions.}

\item{parallel.type}{Character. Parallel backend to use (`"FORK"` or `"PSOCK"`). `"FORK"` is faster but only works on Unix-like systems.}

\item{verbose}{Logical. If `TRUE`, prints progress and filtering information to the console.}

\item{rm_outlier}{Logical. If `TRUE`, uses Bonferroni-Holm corrected residuals to remove outliers before estimating cluster centers.}

\item{cluster_median}{Logical. If `TRUE`, uses the median of theta values to estimate cluster centers. If `FALSE`, uses the mean.}
}
\value{
An object of class `"qploidy_standardization"` (list) with the following components:
\describe{
  \item{info}{Named vector of standardization parameters.}
  \item{filters}{Named vector summarizing how many markers were removed at each filtering step.}
  \item{data}{A data.frame containing merged BAF, Z-score, and genotype information by marker and sample.}
}
}
\description{
This function performs signal standardization of genotype data by aligning `theta` values
(allelic ratios or normalized intensities) to expected genotype clusters. It outputs
standardized BAF (B-allele frequency) and Z-scores per sample and marker.
}
\details{
Reference genotypes are used to estimate cluster centers either from dosage data
(e.g., via `fitpoly` or `updog`) or using an `updog` `multidog` object directly.
This function supports both array-based (intensity) and sequencing-based (count) data.

It applies marker and genotype-level quality filters, uses parallel computing
to estimate BAF, and generates a final annotated output suitable for CNV or
dosage variation analyses.
}
