% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clustering_functions.R
\name{predict.pkbc}
\alias{predict.pkbc}
\alias{predict,pkbc-method}
\title{Cluster spherical observations using a mixture of Poisson kernel-based
densities}
\usage{
\S4method{predict}{pkbc}(object, k, newdata = NULL)
}
\arguments{
\item{object}{Object of class \code{pkbc}}

\item{k}{Number of clusters to be used.}

\item{newdata}{a data.frame or a matrix of the data. If missing the
clustering data obtained from the \code{pkbc} object are
classified.}
}
\value{
Returns a list with the following components
\itemize{
\item Memb: vector of predicted memberships of \code{newdata}
\item Probs: matrix where entry (i,j) denotes the probability that
observation i belongs to the k-th cluster.
}
}
\description{
Obtain predictions of membership for spherical observations based on a
mixture of Poisson kernel-based densities estimated by \code{pkbc}
}
\examples{
# generate data
dat <- rbind(matrix(rnorm(100), ncol = 2), matrix(rnorm(100, 5), ncol = 2))
res <- pkbc(dat, 2)

# extract membership of dat
predict(res, k = 2)
# predict membership of new data
newdat <- rbind(matrix(rnorm(10), ncol = 2), matrix(rnorm(10, 5), ncol = 2))
predict(res, k = 2, newdat)
 
}
\seealso{
\code{\link[=pkbc]{pkbc()}} for the clustering algorithm \cr
\linkS4class{pkbc} for the class object definition.
}
