% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/controlRel.R
\name{controlRel}
\alias{controlRel}
\title{Parameters for reliability calculations}
\usage{
controlRel(
  n.resamples = 100,
  n.cores = 2,
  SSRmethod = "permutation",
  fn = NA,
  MC.reps = 1000,
  d.steps = 10
)
}
\arguments{
\item{n.resamples}{number of resamples for split-sample reliability method}

\item{n.cores}{number of cores to use for parallel processing}

\item{SSRmethod}{use either the \code{permutation} (default) or the \code{bootstrap} method for the split-sample reliability calculation}

\item{fn}{aggregation function for observations within entities, default is \code{NA} and will produce entity-level means}

\item{MC.reps}{number of Monte Carlo simulations to produce reliability estimates for data modeled with hierarchical logistic regression}

\item{d.steps}{number of percentiles removed to check for misclassification probabilities}
}
\value{
control parameters for performance calculations
}
\description{
This function stores parameters for reliability calculations.
}
\examples{
str(controlRel())
}
\author{
Kenneth Nieser (nieser@stanford.edu)
}
