% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fmx_init.R
\name{fmx_cluster}
\alias{fmx_cluster}
\title{Naive Estimates of Finite Mixture Distribution via Clustering}
\usage{
fmx_cluster(
  x,
  K,
  distname = c("GH", "norm", "sn"),
  constraint = character(),
  ...
)
}
\arguments{
\item{x}{\link[base]{numeric} \link[base]{vector}, observations}

\item{K}{\link[base]{integer} scalar, number of mixture components}

\item{distname}{\link[base]{character} scalar, name of parametric distribution of the mixture components}

\item{constraint}{\link[base]{character} \link[base]{vector},
parameters (\eqn{g} and/or \eqn{h} for Tukey \eqn{g}-&-\eqn{h} mixture) to be set at 0.
See function \link[fmx]{fmx_constraint} for details.}

\item{...}{additional parameters, currently not in use}
}
\value{
Function \code{\link[=fmx_cluster]{fmx_cluster()}} returns an \link[fmx:fmx-class]{fmx} object.
}
\description{
Naive estimates for finite mixture distribution \link[fmx:fmx-class]{fmx} via clustering.
}
\details{
First of all, if the specified number of components \eqn{K\geq 2},
trimmed \eqn{k}-means clustering with re-assignment will be performed;
otherwise, all observations will be considered as one single cluster.
The standard \eqn{k}-means clustering is not used since the heavy tails of
Tukey \eqn{g}-&-\eqn{h} distribution could be mistakenly classified as individual cluster(s).

In each of the one or more clusters,
\itemize{
\item{\link[TukeyGH77]{letterValue}-based estimates of Tukey \eqn{g}-&-\eqn{h} distribution (Hoaglin, 2006)
are calculated, for any \eqn{K\geq 1}, serving as the starting values for
QLMD algorithm.
These estimates are provided by function \code{\link[=fmx_cluster]{fmx_cluster()}}.}

\item{the \link[stats]{median} and \link[stats]{mad} will serve as
the starting values for \eqn{\mu} and \eqn{\sigma}
(or \eqn{A} and \eqn{B} for Tukey \eqn{g}-&-\eqn{h} distribution, with \eqn{g = h = 0}),
for QLMD algorithm
when \eqn{K = 1}.}
}
}
