% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/optimize_bigM.R
\name{optimize_bigM}
\alias{optimize_bigM}
\title{Optimize the M parameter during denovo stacks assembly}
\usage{
optimize_bigM(
  M1 = NULL,
  M2 = NULL,
  M3 = NULL,
  M4 = NULL,
  M5 = NULL,
  M6 = NULL,
  M7 = NULL,
  M8 = NULL
)
}
\arguments{
\item{M1}{Path to the input vcf file for a run when M=1}

\item{M2}{Path to the input vcf file for a run when M=2}

\item{M3}{Path to the input vcf file for a run when M=3}

\item{M4}{Path to the input vcf file for a run when M=4}

\item{M5}{Path to the input vcf file for a run when M=5}

\item{M6}{Path to the input vcf file for a run when M=6}

\item{M7}{Path to the input vcf file for a run when M=7}

\item{M8}{Path to the input vcf file for a run when M=8}
}
\value{
A list containing four summary dataframes,
'snp' showing the number of non-missing SNPs retained in each sample at each m value, 'loci' showing the
number of non-missing loci retained in each sample at each m value, 'snp.R80' showing the total number of SNPs
retained at an 80\% completeness cutoff, and 'loci.R80' showing the total number of polymorphic loci
retained at an 80\% completeness cutoff.
}
\description{
This function requires the path to stacks vcf file(s) as input.
There are slots for varying the M parameter from 1-8 (as recommended by Paris et al. 2017).
After running stacks with each of the M options, plug the output vcf files into this
function to calculate the effect of varying M on the number of SNPs/loci built. Plug the output of this function into
vis_loci() to visualize the optimal the M parameter for your dataset at the 'R80' cutoff (Paris et al. 2017).
}
\examples{
optimize_bigM(M1=system.file("extdata","bigM1.vcf.gz",package="RADstackshelpR",mustWork=TRUE))
}
