% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CADEparamreg.R
\name{CADEparamreg}
\alias{CADEparamreg}
\title{Regression-based method for the ITT effects and the complier average direct effect/spillover effect}
\usage{
CADEparamreg(data, assign.prob, ci.level = 0.95)
}
\arguments{
\item{data}{A data frame containing the relevant variables. The names for the variables should be: ``Z'' for the treatment assignment,  ``D''  for the actual received treatment, ``Y'' for the outcome, ``A'' for the treatment assignment mechanism and ``id'' for the cluster ID. The variable for the cluster id should be a factor.}

\item{assign.prob}{A double between 0 and 1 specifying the assignment probability to either assignment mechanism.}

\item{ci.level}{A double between 0 and 1 specifying the confidence interval level to be output.}
}
\value{
A list of class \code{CADEparamreg} which contains the following items:
\item{ITT.DE}{ Estimate of direct effect under ITT regresion. }\item{ITT.SE}{ Estimate of spillover effect under ITT regresion. }
\item{ITT.DE.CI}{ Confidence itnerval of direct effect under ITT regresion. }
\item{ITT.SE.CI}{ Confidence itnerval of spillover effect under ITT regresion. }
\item{IV.DE}{ Estimate of direct effect under IV regresion. }\item{IV.SE}{ Estimate of spillover effect under IV regresion. }
\item{IV.DE.CI}{ Confidence interval of direct effect under IV regresion. }
\item{IV.SE.CI}{ Confidence interval of spillover effect under IV regresion. }
\item{IV.DE.CI}{ Confidence interval of direct effect under IV regresion. }
\item{ITT.tstat}{ t-stats from ITT regression. }\item{IV.tstat}{ t-stats from IV regression. }
\item{ITT.pvals}{ p-values from ITT regression. }\item{IV.pvals}{ p-values from IV regression. }

data(india)
india$id <- factor(india$id)
CADEreg(india, ci.level = 0.90)
}
\description{
This function computes the point estimates and variance estimates of the direct effect and spillover effect for ITT and CADE/CASE
}
\details{
For the details of the method implemented by this function, see the
references.
}
\references{
Kosuke Imai, Zhichao Jiang and Anup Malani (2018).
\dQuote{Causal Inference with Interference and Noncompliance in the Two-Stage Randomized Experiments}, \emph{Technical Report}. Department of Politics, Princeton
University.
}
\author{
Kosuke Imai, Department of Statistics, Harvard University
\email{imai@harvard.edu}, \url{https://imai.fas.harvard.edu/};
Zhichao Jiang, School of Public Health and Health Sciences, University of Massachusetts Amherst
\email{zhichaojiang@umass.edu};
Karissa Huang, Department of Statistics, Harvard College
\email{krhuang@college.harvard.edu}
}
\keyword{experiments}
\keyword{randomized}
\keyword{two-stage}
