% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RDML.types.R
\docType{class}
\name{loopType}
\alias{loopType}
\title{loopType R6 class.}
\format{
An \code{\link[R6]{R6Class}} generator object.
}
\description{
This step allows to form a loop or to exclude some steps. It allows to jump
to a certain "goto" step for "repeat" times. If the "goto" step is outside of
the loop range, it must have "repeat" value "0". Inherits:
\link{rdmlBaseType}.
}
\section{Initialization}{
 \preformatted{loopType$new(goto, repeat.n)}
}

\section{Fields}{
 \describe{ \item{\code{goto}}{\link[checkmate]{assertCount}.  The
  step to go to to form the loop.}
\item{\code{repeat.n}}{\link[checkmate]{assertCount}. Determines how many times the loop is
  repeated. The first run through the loop is counted as 0, the last loop is
  "repeat" - 1.}}
}

\section{Super class}{
\code{\link[RDML:rdmlBaseType]{RDML::rdmlBaseType}} -> \code{loopType}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-loopType-new}{\code{loopType$new()}}
\item \href{#method-loopType-clone}{\code{loopType$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="RDML" data-topic="rdmlBaseType" data-id=".asXMLnodes"><a href='../../RDML/html/rdmlBaseType.html#method-rdmlBaseType-.asXMLnodes'><code>RDML::rdmlBaseType$.asXMLnodes()</code></a></span></li>
<li><span class="pkg-link" data-pkg="RDML" data-topic="rdmlBaseType" data-id="copy"><a href='../../RDML/html/rdmlBaseType.html#method-rdmlBaseType-copy'><code>RDML::rdmlBaseType$copy()</code></a></span></li>
<li><span class="pkg-link" data-pkg="RDML" data-topic="rdmlBaseType" data-id="print"><a href='../../RDML/html/rdmlBaseType.html#method-rdmlBaseType-print'><code>RDML::rdmlBaseType$print()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-loopType-new"></a>}}
\if{latex}{\out{\hypertarget{method-loopType-new}{}}}
\subsection{Method \code{new()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{loopType$new(goto, repeat.n)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-loopType-clone"></a>}}
\if{latex}{\out{\hypertarget{method-loopType-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{loopType$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
