% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RDnp_Test.R
\name{RDnp_Test}
\alias{RDnp_Test}
\title{Robust Test for Independence in High-Dimensional Data}
\usage{
RDnp_Test(X, alpha = 0.75)
}
\arguments{
\item{X}{the data. It must be matrix.}

\item{alpha}{numeric parameter. It gives the rate of uncontaminated observations.
Allowed values are between 0.5 and 1 and the default is 0.75.}
}
\value{
a list with 2 elements:
\item{TestValue}{The value of test statistic}
\item{pval}{The p value}
\item{robust}{Logical. Indicates whether the results are based on robust
 statistic. Here, it returns \code{robust=TRUE}}
}
\description{
A Robust Test Statistic for Independence in High-Dimensional Datasets
}
\details{
\code{RDnp_Test} function tests the complete independence in high-dimensional
data sets without being affected by outliers.
}
\examples{

# Under H0
library(MASS)
data_H0<-mvrnorm(n = 20,mu = rep(0,30),Sigma = diag(30))
RDnp_Test(data_H0)

# Under H1
library(MASS)
data_H1<-mvrnorm(n = 20,mu = rep(0,30),Sigma = (diag(30)+1))
RDnp_Test(data_H1)
}
\references{
Bulut, H (Unpublished). A Robust Test Statistic for Independence in High Dimensional Data
}
\author{
Hasan BULUT <hasan.bulut@omu.edu.tr>
}
