% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gendata.R
\name{gendata}
\alias{gendata}
\title{Data generation process}
\usage{
gendata(seed = 1, T = 50, N = 50, type = "1a")
}
\arguments{
\item{seed}{The \code{seed} used in the data generation process.}

\item{T}{Time dimension.}

\item{N}{Cross-sectional dimension.}

\item{type}{The type of the data generation process. Options include "1a", "1b", "1c", "1d", "2a", "2b", "2c", "2d", "3a", "3b".}
}
\value{
A list containing:
\item{Y}{The observed matrix.}
\item{F0}{The true factor matrix.}
\item{L0}{The true loading matrix.}
}
\description{
Generate heavy-tailed data.
}
\examples{
dat = gendata()
Y = dat$Y
head(Y)

}
\references{
Robust factor analysis with exponential squared loss. Jiaqi Hu, Tingyin Wang, Xueqin Wang. Journal of Multivariate Analysis 2026, 213 105567; doi:10.1016/j.jmva.2025.105567
}
\author{
Jiaqi Hu
}
