% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plotCalibration}
\alias{plotCalibration}
\title{Calibration plot}
\usage{
plotCalibration(
  fit,
  legend.position = "none",
  trueValue = NULL,
  criterion = BICc,
  dismin = TRUE
)
}
\arguments{
\item{fit}{fit object of class cvRemix, from \code{\link{cv.remix}}.}

\item{legend.position}{(default NULL)     the default position of legends ("none", "left", "right", "bottom", "top", "inside").}

\item{trueValue}{(for simulation purpose) named vector containing the true value of regularization parameter.}

\item{criterion}{function ; which criterion among 'BIC', 'eBIC', 'AIC', 'BICc', or function of cvRemix object to take into account (default : BICc).}

\item{dismin}{logical ; if minimizers of information criterion should be display.}
}
\value{
Calibration plot, over the lambda.grid.
}
\description{
Calibration plot
}
\examples{
\dontrun{
project <- getMLXdir()

ObsModel.transfo = list(S=list(AB=log10),
                        linkS="yAB",
                        R=rep(list(S=function(x){x}),5),
                        linkR = paste0("yG",1:5))

alpha=list(alpha0=NULL,
           alpha1=setNames(paste0("alpha_1",1:5),paste0("yG",1:5)))

y = c(S=5,AB=1000)

res = cv.remix(project = project,
               dynFUN = dynFUN_demo,
               y = y,
               ObsModel.transfo = ObsModel.transfo,
               alpha = alpha,
               selfInit = TRUE,
               eps1=10**(-2),
               ncores=8,
               nlambda=8,
               eps2=1)

plotCalibration(res)

plotIC(res)
}
}
\seealso{
\code{\link{remix}}, \code{\link{cv.remix}}.
}
