% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prediction_model.v16.R
\name{ci.curve}
\alias{ci.curve}
\title{Confidence bands}
\usage{
ci.curve(
  fit = NULL,
  H.E = NULL,
  H.W = NULL,
  scenario = NULL,
  cases = NULL,
  cfg = NULL,
  restrictions = NULL,
  restriction.starts = NULL,
  ranges = NULL,
  rt_func = 1,
  fit.t.pred = NULL,
  predict.beyond = 0,
  lt = NULL,
  adj.period = NULL,
  population = NULL,
  rho = NULL,
  serial_mean = NULL,
  serial_var = NULL,
  window_size = NULL,
  eps = .Machine$double.eps^(1/2)
)
}
\arguments{
\item{fit}{Output from function estimate.mle.}

\item{H.E}{Mobility metrics for category Retail & Entertainment. Currently unsupported.}

\item{H.W}{Mobility metrics for category Workplaces. Currently unsupported.}

\item{scenario}{A character string describing options to deal with restrictions. Currently unsupported.}

\item{cases}{vector of case counts.}

\item{cfg}{The object that contains all variables from the configuration file.
\code{fit}, \code{H.E}, \code{H.W}, \code{scenario}, and \code{cases} are also required
for the method to execute. All other parameters will not be used if \code{cfg} is passed to the method.}

\item{restrictions}{A numeric integer vector giving the severity of restrictions.
Zero means no restriction, and higher numbers means greater severity/disruption.
The ordered unique values should be consecutive integers starting from zero.
Each number (other than 0) adds a new parameter to the fit.}

\item{restriction.starts}{A vector of same length as restrictions, of times when restrictions
came into effect. Note: the first index time should be 1.}

\item{ranges}{A vector of time ranges for the different waves.
The wave ranges should be contiguous, with at least one unit of time
between consecutive waves.}

\item{rt_func}{The parametric form of function c(). Options are listed under function c_helper.}

\item{fit.t.pred}{Time from which prediction is done. If use.actual.not.predicted is TRUE, values of \eqn{S_t} before this time will be computed using actual counts.}

\item{predict.beyond}{Number of days to predict beyond the end of \code{cases}. See Details for usage notes.}

\item{lt}{The length of cases.}

\item{adj.period}{Adjustment period following a change in severity level. Restriction level (psi) is linearly interpolated from the old to the new value over this period.}

\item{population}{Total population size.}

\item{rho}{A vector of under-reporting rates of the same length as cases. If a scalar is supplied, the vector will be constant with this value.}

\item{serial_mean}{Mean of the serial interval on the log scale.}

\item{serial_var}{Variance of the serial interval on the log scale.}

\item{window_size}{The maximum value for the serial interval.}

\item{eps}{The epsilon value for computing finite differences.}
}
\value{
Returns a matrix with two rows containing Wald-style confidence bounds:
   \itemize{
     \item ci_lower - lower bound of a 95\% pointwise CI of the best fit curve.
     \item ci_upper - upper bound of a 95\% pointwise CI of the best fit curve.
   }
}
\description{
Computes the pointwise confidence interval of the epidemic curve.
}
\examples{
library(REffectivePred)
## Read in the data
path_to_data <- system.file("extdata/NY_OCT_4_2022.csv", package = "REffectivePred")
data <- read.csv(path_to_data)
head(data)
cases <- diff(c(0, data$cases)) # Convert cumulative cases into daily cases
lt <- length(cases)             # Length of cases
Time <- as.Date(data$date, tryFormats = c("\%d-\%m-\%Y", "\%d/\%m/\%Y"))

navigate_to_config() # Open the config file, make any necessary changes here.
path_to_config <- system.file("config.yml", package = "REffectivePred")  # Read config file
cfg <- load_config()    # Build the cfg object

# Estimate parameters
est <- estimate.mle(
    cases = cases,
    cfg = cfg,
    hessian = TRUE
    )
a1 <- est$a1
a2 <- est$a2
a3 <- est$a3
a4 <- est$a4
nu <- est$nu
vt <- c(1, est$vt_params_est)
psi <- est$Psi
betas <- est$betas

# Predict curve
r1 <- pred.curve(
a1 = a1,
a2 = a2,
a3 = a3,
a4 = a4,
nu = nu,
variant.transm = vt,
Psi = psi,
betas = betas,
cases = cases,
cfg = cfg
)

plot_outputs(Time = Time,
cases = cases,
cfg = cfg,
curve = r1,
option = 2
)

bounds <- ci.curve(fit = est,
                   cases = cases,
                   cfg = cfg)

# Adding CI bands
# lines(c(Time, Time[length(Time)]+(1:predict.beyond)), bounds[2,], lty = 2)
# lines(c(Time, Time[length(Time)]+(1:predict.beyond)), bounds[1,], lty = 2)


}
