% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/discriminator-architectures.R
\name{DCGAN_Discriminator}
\alias{DCGAN_Discriminator}
\title{DCGAN Discriminator}
\usage{
DCGAN_Discriminator(
  number_channels = 3,
  ndf = 64,
  dropout_rate = 0.5,
  sigmoid = FALSE
)
}
\arguments{
\item{number_channels}{The number of channels in the image (RGB is 3 channels)}

\item{ndf}{The number of feature maps in discriminator}

\item{dropout_rate}{The dropout rate for each hidden layer}

\item{sigmoid}{Switch between a sigmoid and linear output layer (the sigmoid is needed for the original GAN value function)}
}
\value{
A torch::nn_module for the DCGAN Discriminator
}
\description{
Provides a torch::nn_module with a simple deep convolutional neural
net architecture, for use as the default architecture for image data in RGAN.
Architecture inspired by: \url{https://pytorch.org/tutorials/beginner/dcgan_faces_tutorial.html}
}
