% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gspaceGeom.R
\name{geom_edgespace}
\alias{geom_edgespace}
\title{Draw edge elements in a 2D graph layout}
\usage{
geom_edgespace(
  mapping = NULL,
  data = NULL,
  stat = "identity",
  position = "identity",
  ...,
  show.legend = NA,
  inherit.aes = FALSE,
  lineend = "butt",
  linejoin = "mitre",
  arrow_type = 0,
  arrow_size = 1,
  offset_start = 0,
  offset_end = 0
)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by [ggplot2::aes()].
These mappings apply to the layer and may override global aesthetics.}

\item{data}{Either a \linkS4class{GraphSpace} object or a data frame 
containing edge attributes. If `NULL`, the layer will use the default 
plot data.}

\item{stat}{The statistical transformation to use on the data.
Defaults to `"identity"`.}

\item{position}{Position adjustment, either as a string or
the result of a call to a position adjustment function.}

\item{...}{Additional parameters passed to the underlying
drawing function in `GeomEdgeSpace`.}

\item{show.legend}{Logical or a named logical vector indicating
whether this layer should be included in legends.}

\item{inherit.aes}{Logical. If `FALSE` (default), the layer will use 
aesthetics defined in `mapping`. Set to `TRUE` if this geom should 
inherit aesthetics from the plot.}

\item{lineend}{Line end style (round, butt, square).}

\item{linejoin}{Line join style (round, mitre, bevel).}

\item{arrow_type}{Arrowhead types (see 'drawing' section).}

\item{arrow_size}{Numeric scaling factor controlling arrowhead geometry.}

\item{offset_start}{Offset arrows as a fraction of graph space at
start positions.}

\item{offset_end}{Offset arrows as a fraction of graph space at
end positions.}
}
\value{
A ggplot2 layer that renders edge segments defined by
\code{\link{GeomEdgeSpace}}.
}
\description{
Constructor for \code{\link{GeomEdgeSpace}} ggproto objects, a variant 
of \code{\link[ggplot2]{geom_segment}} supporting edge attributes and 
bidirectional arrows.

This `geom` is designed to create edge-level aesthetics such as `colour` 
and `linewidth`, or any custom aesthetics defined in `GeomEdgeSpace`.
}
\details{
Arrowhead size is a numeric scaling factor controlling arrowhead geometry. 
The value is interpreted in the same numeric space as line width (`lwd`), 
ensuring consistent scaling between edge strokes and arrowheads.

Arrowhead types can be specified using either integer or character codes:\cr
- No arrow: \code{0 or "---"}\cr
- Forward arrow: \code{1 or "-->"}\cr
- Backward arrow: \code{2 or "<--"}\cr
- Bidirectional arrow: \code{3 or "<->"}\cr
- Forward arrow with backward bar: \code{4 or "|->"}\cr
- Forward bar: \code{-1 or "--|"}\cr
- Backward bar: \code{-2 or "|--"}\cr
- Bidirectional bar: \code{-3 or "|-|"}\cr
- Backward arrow with forward bar: \code{-4 or "<-|"}\cr
}
\section{Aesthetics}{


`geom_edgespace` understands the following aesthetics:

\itemize{
  \item `x` Starting horizontal position in 
  `npc` \code{\link[grid]{unit}} (required).
  \item `y` Starting vertical position in 
  `npc` \code{\link[grid]{unit}} (required).
  \item `xend` Ending horizontal position in 
  `npc` \code{\link[grid]{unit}} (required).
  \item `yend` Ending vertical position in 
  `npc` \code{\link[grid]{unit}} (required).
  \item `colour` Edge colour.
  \item `linewidth` Edge width, using 'lwd' standard graphics unit 
  (see \code{\link[grid]{gpar}}).
  \item `linetype` Line type, using 'lty' standard graphics unit 
  (see \code{\link[grid]{gpar}}).
  \item `alpha` Transparency applied to the edge colour.
}
}

\examples{

# Load a demo igraph
data('gtoy1', package = 'RGraphSpace')

# Create a GraphSpace object
gs <- GraphSpace(gtoy1)

\dontrun{

ggplot() + geom_edgespace(aes(x = x, y = y, xend = xend, yend = yend),
  data = gs) + theme(aspect.ratio = 1) + 
  scale_x_continuous(limits = c(0, 1)) +
  scale_y_continuous(limits = c(0, 1))

}

}
\seealso{
\code{\link{GeomEdgeSpace}}, \linkS4class{GraphSpace}
}
