% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{runDirectMethod}
\alias{runDirectMethod}
\title{Convenience function to simulate the direct method for the specified subset}
\usage{
runDirectMethod(tableTCs = NULL, N = 120, cutoffZ = 5)
}
\arguments{
\item{tableTCs}{(data frame) containing the pre-defined parameter combinations to generate the simulations}

\item{N}{(integer) specifying the number of samples used as sample size for the direct method, default: 120}

\item{cutoffZ}{(numeric) specifying if a cutoff should be used to classify results as implausible and exclude from analysis}
}
\value{
(data frame) with computed performance measures
}
\description{
Convenience function to simulate the direct method for the specified subset
}
\examples{

\donttest{
# example to run direct method only for test sets for hemoglobin (Hb)
testsets <- loadTestsetDefinition()
directRes <- runDirectMethod(tableTCs = testsets[testsets$Analyte =="Hb",], N = 120, cutoffZ = 5)
} 

}
\author{
Tatjana Ammer \email{tatjana.ammer@roche.com}
}
