% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RKorAPClient-package.R
\docType{package}
\name{RKorAPClient-package}
\alias{RKorAPClient}
\alias{RKorAPClient-package}
\title{R Client for KorAP Corpus Analysis Platform}
\description{
RKorAPClient provides programmatic access to KorAP corpus analysis platform instances,
enabling corpus linguistic research on large corpora like DeReKo, CoRoLa, DeLiKo@DNB.
}
\section{Main Functions}{

\describe{
\item{Connection}{\code{KorAPConnection()}, \code{auth()}, \code{persistAccessToken()}}
\item{Search}{\code{corpusQuery()}, \code{fetchAll()}, \code{fetchNext()}}
\item{Analysis}{\code{corpusStats()}, \code{frequencyQuery()}, \code{collocationAnalysis()}}
}
}

\section{Quick Start}{


\if{html}{\out{<div class="sourceCode r">}}\preformatted{library(RKorAPClient)
# Connect and search
kcon <- KorAPConnection()
query <- corpusQuery(kcon, "Ameisenplage")
results <- fetchAll(query)

# Access results
results@collectedMatches
results@totalResults
}\if{html}{\out{</div>}}
}

\section{Common Workflows}{


\strong{Basic Search:}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{kcon <- KorAPConnection()
kcon |> corpusQuery("search term") |> fetchAll()
}\if{html}{\out{</div>}}

\strong{Frequency Analysis:}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{frequencyQuery(kcon, c("term1", "term2"), vc="pubDate in 2020")
}\if{html}{\out{</div>}}

\strong{Corpus Statistics:}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{corpusStats(kcon, vc="textType=Zeitung", as.df=TRUE)
}\if{html}{\out{</div>}}
}

\references{
Kupietz, Marc / Diewald, Nils / Margaretha, Eliza (2020):
RKorAPClient: An R package for accessing the German Reference Corpus DeReKo
via KorAP. In: Calzolari, Nicoletta, Frédéric Béchet, Philippe Blache,
Khalid Choukri, Christopher Cieri,  Thierry Declerck, Sara Goggi,
Hitoshi Isahara, Bente Maegaard, Joseph Mariani, Hélène Mazo,
Asuncion Moreno, Jan Odijk, Stelios Piperidis (eds.):
Proceedings of The 12th Language Resources and Evaluation Conference (LREC 2020)
Marseille: European Language Resources Association (ELRA), 7017-7023.
\url{http://www.lrec-conf.org/proceedings/lrec2020/pdf/2020.lrec-1.867.pdf}
}
\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/KorAP/RKorAPClient/}
  \item \url{https://korap.ids-mannheim.de/}
  \item \url{https://www.ids-mannheim.de/digspra/kl/projekte/korap}
  \item Report bugs at \url{https://github.com/KorAP/RKorAPClient/issues}
}

}
\author{
\strong{Maintainer}: Marc Kupietz \email{kupietz@ids-mannheim.de}

Other contributors:
\itemize{
  \item Nils Diewald \email{diewald@ids-mannheim.de} [contributor]
  \item Leibniz Institute for the German Language [copyright holder, funder]
}

}
\keyword{internal}
